/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import java.security.cert.CertPathValidatorException;

public class CertKeyUsage {
    private final boolean[] values;
    private final boolean enabled;

    public CertKeyUsage(boolean[] values) {
        this.values = values;
        this.enabled = values != null && values.length != 0;
    }

    public static CertKeyUsage check(boolean[] values) throws CertPathValidatorException {
        if (values != null && values.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1);
        }
        return new CertKeyUsage(values);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean enabledSigning() {
        return this.enabled(KeyUsage.digitalSignature) || this.enabled(KeyUsage.nonRepudiation) || this.enabled(KeyUsage.keyCertSign) || this.enabled(KeyUsage.cRLSign);
    }

    public boolean digitalSignature() {
        return this.enabled(KeyUsage.digitalSignature);
    }

    public boolean keyEncipherment() {
        return this.enabled(KeyUsage.keyEncipherment);
    }

    public boolean dataEncipherment() {
        return this.enabled(KeyUsage.dataEncipherment);
    }

    public boolean keyAgreement() {
        return this.enabled(KeyUsage.keyAgreement);
    }

    private boolean enabled(KeyUsage keyUsage) {
        int bitsIndex = keyUsage.bitsIndex;
        return this.enabled && this.values.length > bitsIndex && this.values[bitsIndex];
    }

    public static enum KeyUsage {
        digitalSignature(0),
        nonRepudiation(1),
        keyEncipherment(2),
        dataEncipherment(3),
        keyAgreement(4),
        keyCertSign(5),
        cRLSign(6),
        encipherOnly(7),
        decipherOnly(8);

        final int bitsIndex;

        private KeyUsage(int bit) {
            this.bitsIndex = bit;
        }

        final boolean getEnabled(boolean[] keyUsage) {
            boolean enable = false;
            if (keyUsage != null && this.bitsIndex < keyUsage.length) {
                enable = keyUsage[this.bitsIndex];
            }
            return enable;
        }
    }
}

