/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfParameters;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import cfca.sadk.tls.util.Utilities;
import java.io.IOException;
import java.security.ProviderException;
import javax.crypto.SecretKey;

public final class Finished
extends HandshakeMessage {
    public static final int CLIENT = 1;
    public static final int SERVER = 2;
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    private ProtocolVersion protocolVersion;
    private CipherSuite cipherSuite;
    private byte[] verifyData;

    public Finished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int sender, SecretKey master, CipherSuite cipherSuite) {
        this.protocolVersion = protocolVersion;
        this.cipherSuite = cipherSuite;
        this.verifyData = this.callFinished(handshakeHash, sender, master);
    }

    public Finished(ProtocolVersion protocolVersion, HandshakeInStream in, CipherSuite cipherSuite) throws IOException {
        this.protocolVersion = protocolVersion;
        this.cipherSuite = cipherSuite;
        this.verifyData = new byte[12];
        in.read(this.verifyData);
    }

    public boolean verify(HandshakeHash handshakeHash, int sender, SecretKey master) {
        byte[] myFinished = this.callFinished(handshakeHash, sender, master);
        return Utilities.equals(myFinished, this.verifyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] callFinished(HandshakeHash handshakeHash, int sender, SecretKey masterKey) {
        String tlsLabel;
        if (!this.protocolVersion.isChinaTLS11()) {
            throw new ProviderException("Invalid protocolVersion, version must be ChinaTLS11");
        }
        if (sender == 1) {
            tlsLabel = "client finished";
        } else if (sender == 2) {
            tlsLabel = "server finished";
        } else {
            throw new RuntimeException("Invalid sender: " + sender);
        }
        TlsPrfParameters params = null;
        try {
            byte[] hash = handshakeHash.getFinishedHash();
            HashPRF prf = this.cipherSuite.prfAlg;
            params = new TlsPrfParameters(masterKey, tlsLabel, hash, 12, prf);
            SecretKey prfKey = params.generateKey();
            if (!"RAW".equals(prfKey.getFormat())) {
                throw new ProviderException("Invalid PRF output, format must be RAW");
            }
            byte[] byArray = prfKey.getEncoded();
            return byArray;
        }
        finally {
            params = null;
        }
    }

    public byte[] getVerifyData() {
        return this.verifyData;
    }

    @Override
    public final int messageType() {
        return 20;
    }

    @Override
    final int messageLength() {
        return this.verifyData.length;
    }

    @Override
    final void send(HandshakeOutStream out) throws IOException {
        out.write(this.verifyData);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append("\n*** Finished");
        builder.append("\n***");
        return builder.toString();
    }
}

