/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPremasterSecretGenerator;
import cfca.sadk.tls.sun.security.ssl.prf.TlsProtocolVersion;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public final class TlsPremasterSecretParameters {
    private final TlsProtocolVersion versions;
    private byte[] encodedSecret;

    public TlsPremasterSecretParameters(int majorVersion, int minorVersion) {
        this.versions = new TlsProtocolVersion(majorVersion, minorVersion);
        this.encodedSecret = null;
    }

    public TlsPremasterSecretParameters(int majorVersion, int minorVersion, byte[] encodedSecret) {
        this(majorVersion, minorVersion);
        if (encodedSecret == null || encodedSecret.length != 48) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.premasterSecretEncodedNotExactly"));
        }
        this.encodedSecret = (byte[])encodedSecret.clone();
    }

    public int getMajorVersion() {
        return this.versions.majorVersion;
    }

    public int getMinorVersion() {
        return this.versions.minorVersion;
    }

    public byte[] getEncodedSecret() {
        return this.encodedSecret == null ? null : (byte[])this.encodedSecret.clone();
    }

    public final SecretKey generatePremasterkey() throws CryptoException {
        return TlsPremasterSecretGenerator.INSTANCE.generatePremasterKey(this);
    }

    public final SecretKey generatePremasterkey(SecureRandom secure) throws CryptoException {
        return TlsPremasterSecretGenerator.INSTANCE.generatePremasterKey(this, secure);
    }
}

