/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBulk;
import cfca.sadk.tls.sun.security.ssl.sec.KeyExchangeAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.MacAlg;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class CipherSuite
implements Comparable<CipherSuite> {
    public static final boolean DYNAMIC_AVAILABILITY = true;
    public static final int SUPPORTED_SUITES_PRIORITY = 1;
    public static final int DEFAULT_SUITES_PRIORITY = 300;
    private static final Map<Integer, CipherSuite> idMap = new HashMap<Integer, CipherSuite>();
    private static final Map<String, CipherSuite> nameMap = new HashMap<String, CipherSuite>();
    public String name;
    public final int id;
    public final int priority;
    public final KeyExchangeAlgorithm keyExchange;
    public final CipherBulk cipher;
    public final MacAlg macAlg;
    public final HashPRF prfAlg;
    public final boolean exportable;
    public final boolean allowed;
    public final int obsoleted;
    public final int supported;
    public static final CipherSuite C_NULL;
    public static final CipherSuite C_SCSV;

    private CipherSuite(String name, int id, int priority, KeyExchangeAlgorithm keyExchange, CipherBulk cipher, boolean allowed, int obsoleted, int supported, HashPRF prfAlg) {
        this.name = name;
        this.id = id;
        this.priority = priority;
        this.keyExchange = keyExchange;
        this.cipher = cipher;
        this.exportable = cipher.exportable;
        if (name.endsWith("_SM3")) {
            this.macAlg = MacAlg.SM3;
        } else if (name.endsWith("_NULL")) {
            this.macAlg = MacAlg.NULL;
        } else if (name.endsWith("_SCSV")) {
            this.macAlg = MacAlg.NULL;
        } else {
            throw new IllegalArgumentException("Unknown MAC algorithm for ciphersuite " + name);
        }
        allowed &= keyExchange.allowed;
        this.allowed = allowed &= cipher.allowed;
        this.obsoleted = obsoleted;
        this.supported = supported;
        this.prfAlg = prfAlg;
    }

    private CipherSuite(String name, int id) {
        this.name = name;
        this.id = id;
        this.allowed = false;
        this.priority = 0;
        this.keyExchange = null;
        this.cipher = null;
        this.macAlg = null;
        this.exportable = false;
        this.obsoleted = 65535;
        this.supported = 0;
        this.prfAlg = HashPRF.NONE;
    }

    public boolean isAvailable() {
        return this.allowed && this.keyExchange.isAvailable();
    }

    public boolean isNegotiable() {
        return this != C_SCSV && this.isAvailable();
    }

    @Override
    public int compareTo(CipherSuite o) {
        return o.priority - this.priority;
    }

    public String toString() {
        return this.name;
    }

    public static CipherSuite valueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        CipherSuite suit = nameMap.get(s);
        if (suit == null || !suit.allowed) {
            throw new IllegalArgumentException("Unsupported ciphersuite " + s);
        }
        return suit;
    }

    public static CipherSuite valueOf(int id) {
        CipherSuite c = idMap.get(id);
        if (c == null) {
            c = new CipherSuite("Unknown 0x" + Integer.toString(id, 16), id);
        }
        return c;
    }

    public static CipherSuite decodedFrom(HandshakeInStream in) throws IOException {
        return CipherSuite.valueOf(in.getInt16());
    }

    static String getName(int id) {
        CipherSuite c = idMap.get(id);
        if (c == null) {
            return "Unknown";
        }
        return c.name;
    }

    public static Collection<CipherSuite> allowedCipherSuites() {
        return nameMap.values();
    }

    private static void add(String name, int id, int priority, KeyExchangeAlgorithm keyExchange, CipherBulk cipher, boolean allowed, int obsoleted, int supported, HashPRF prf) {
        CipherSuite c = new CipherSuite(name, id, priority, keyExchange, cipher, allowed, obsoleted, supported, prf);
        if (idMap.put(id, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
        if (c.allowed && nameMap.put(name, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
    }

    private static void add(String name, int id, int priority, KeyExchangeAlgorithm keyExchange, CipherBulk cipher, boolean allowed, int obsoleted) {
        HashPRF prf = HashPRF.SM3;
        CipherSuite.add(name, id, priority, keyExchange, cipher, allowed, obsoleted, 0, prf);
    }

    private static void add(String name, int id, int priority, KeyExchangeAlgorithm keyExchange, CipherBulk cipher, boolean allowed) {
        CipherSuite.add(name, id, priority, keyExchange, cipher, allowed, 65535);
    }

    static final void add(String name, int id) {
        CipherSuite c = new CipherSuite(name, id);
        if (idMap.put(id, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
    }

    static {
        boolean F = false;
        boolean T = true;
        int p = 600;
        int max = 65535;
        int tls11 = ProtocolVersion.TLS11SM.version;
        CipherSuite.add("SSL_NULL_WITH_NULL_NULL", 0, 1, KeyExchangeAlgorithm.K_NULL, CipherBulk.B_NULL, false);
        CipherSuite.add("TLS_ECDHE_SM2DSA_WITH_SM4_CBC_SM3", 57361, --p, KeyExchangeAlgorithm.K_ECDHE_SM2DSA, CipherBulk.B_SM4_128, true, max, tls11, HashPRF.SM3);
        CipherSuite.add("TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3", 57363, --p, KeyExchangeAlgorithm.K_SM2PKEA_SM2DSA, CipherBulk.B_SM4_128, true, max, tls11, HashPRF.SM3);
        CipherSuite.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", 255, --p, KeyExchangeAlgorithm.K_SCSV, CipherBulk.B_NULL, true);
        C_NULL = CipherSuite.valueOf(0);
        C_SCSV = CipherSuite.valueOf(255);
    }
}

