/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.tls.pure.SymEncryption;
import cfca.sadk.tls.pure.impl.JCEEncryption;
import cfca.sadk.tls.util.DeviceConf;
import cfca.sadk.tls.util.Loggings;

public final class CryptoFactory {
    private Session session = null;
    private static volatile CryptoFactory singleton;

    private CryptoFactory() throws PKIException {
        this.setDeviceType(DeviceConf.getDevicetype());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoFactory singleton() throws PKIException {
        if (singleton != null) return singleton;
        Class<CryptoFactory> clazz = CryptoFactory.class;
        synchronized (CryptoFactory.class) {
            if (singleton != null) return singleton;
            singleton = new CryptoFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public final Session session() {
        return this.session;
    }

    public void setDeviceType(String deviceType) throws PKIException {
        if (!"JSOFT_LIB".equals(deviceType) && !"JNISOFT_LIB".equals(deviceType)) {
            Loggings.ENVIRONMENT.info("setDeviceType: {}, DeviceTLS do not support", (Object)deviceType);
            throw new PKIException("DeviceTLS do not support " + deviceType);
        }
        Loggings.ENVIRONMENT.info("setDeviceType: {}", (Object)deviceType);
        JCrypto.getInstance().initialize(deviceType, null);
        Session session = JCrypto.getInstance().openSession(deviceType);
        this.session = session;
    }

    public final SymEncryption getEncryption(String transformation) throws SecurityException {
        return new JCEEncryption(transformation, this.session);
    }
}

