/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2DHAlgorithmParameter;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import cfca.sadk.org.bouncycastle.jce.spec.MQVPublicKeySpec;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.ssl.sec.SSLCredentials;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class ECDHCrypt {
    static final Mechanism SM2 = new Mechanism("SM2");
    private PrivateKey privateKey;
    private ECPublicKey publicKey;

    ECDHCrypt(SSLCredentials cipher) {
        if (cipher == null) {
            throw new RuntimeException("no cipher TLSCredentials");
        }
        this.privateKey = cipher.privateKey;
        this.publicKey = (ECPublicKey)cipher.getCertificate().getPublicKey();
    }

    public ECDHCrypt(boolean smFlag, String curveName, SecureRandom random) {
        this(smFlag, smFlag ? SM2Params.sm2ParameterSpec : ECNamedCurve.getECParameterSpec(curveName), random);
    }

    public ECDHCrypt(boolean smFlag, ECParameterSpec params, SecureRandom random) {
        try {
            KeyPair keypair = null;
            if (!smFlag) {
                throw new SecurityException("ecc not support");
            }
            Session session = CryptoFactory.singleton().session();
            keypair = session.generateKeyPair(SM2, 256);
            this.privateKey = keypair.getPrivate();
            this.publicKey = (ECPublicKey)keypair.getPublic();
        }
        catch (Exception e) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("Could not generate ECDH keypair", (Throwable)e);
            }
            throw new RuntimeException("Could not generate ECDH keypair", e);
        }
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecretKey getSM2AgreedSecret(ECPrivateKey dAClient, ECPublicKey PAClient, ECPublicKey PBServer, ECPublicKey RBServer) {
        try {
            MQVPrivateKeySpec mqvPrivKey = new MQVPrivateKeySpec((PrivateKey)dAClient, this.privateKey, (PublicKey)this.publicKey);
            MQVPublicKeySpec mqvPubKey = new MQVPublicKeySpec((PublicKey)PBServer, (PublicKey)RBServer);
            SM2DHAlgorithmParameter zParams = new SM2DHAlgorithmParameter(PBServer.getQ(), PAClient.getQ());
            KeyAgreement ka = JSSEJCE.getAgreement("SM2");
            ka.init((Key)mqvPrivKey, (AlgorithmParameterSpec)zParams);
            ka.doPhase((Key)mqvPubKey, true);
            byte[] secure = new byte[48];
            ka.generateSecret(secure, 0);
            return new SecretKeySpec(secure, "TlsPremasterSecret");
        }
        catch (Exception e) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("Could not generate secret", (Throwable)e);
            }
            throw new RuntimeException("Could not generate secret", e);
        }
    }

    public SecretKey getSM2AgreedSecret(SSLCredentials credentials, ECPublicKey PAClient, ECPublicKey RAClient) {
        ECPrivateKey dBServer = (ECPrivateKey)credentials.privateKey;
        ECPublicKey PBServer = (ECPublicKey)credentials.publicKey;
        try {
            MQVPrivateKeySpec mqvPrivKey = new MQVPrivateKeySpec((PrivateKey)dBServer, this.privateKey, (PublicKey)this.publicKey);
            MQVPublicKeySpec mqvPubKey = new MQVPublicKeySpec((PublicKey)PAClient, (PublicKey)RAClient);
            SM2DHAlgorithmParameter zParams = new SM2DHAlgorithmParameter(PBServer.getQ(), PAClient.getQ());
            KeyAgreement ka = JSSEJCE.getAgreement("SM2");
            ka.init((Key)mqvPrivKey, (AlgorithmParameterSpec)zParams);
            ka.doPhase((Key)mqvPubKey, true);
            byte[] secure = new byte[48];
            ka.generateSecret(secure, 0);
            return new SecretKeySpec(secure, "TlsPremasterSecret");
        }
        catch (Exception e) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("Could not generate secret", (Throwable)e);
            }
            throw new RuntimeException("Could not generate secret", e);
        }
    }
}

