/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECFieldElement;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.tls.sun.security.ssl.extension.SupportedEllipticCurvesExtension;
import cfca.sadk.tls.util.ECBasisType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public final class ECDHParams {
    private ECDHParams() {
    }

    public static final ECParameterSpec readECParameters(OutputStream out, int curveType, InputStream input) throws IOException {
        out.write(curveType);
        switch (curveType) {
            case 1: {
                BigInteger prime_p = ECDHParams.readECParameter(out, input);
                BigInteger a = ECDHParams.readECFieldElement(out, prime_p.bitLength(), input);
                BigInteger b = ECDHParams.readECFieldElement(out, prime_p.bitLength(), input);
                byte[] baseEncoding = ECDHParams.getBytes8From(input);
                ECDHParams.putBytes8To(out, baseEncoding);
                BigInteger order = ECDHParams.readECParameter(out, input);
                BigInteger cofactor = ECDHParams.readECParameter(out, input);
                ECCurve.Fp curve = new ECCurve.Fp(prime_p, a, b, order, cofactor);
                if (baseEncoding == null || baseEncoding.length < 1) {
                    throw new SSLHandshakeException("Invalid ECParameter: encoding");
                }
                ECPoint base = curve.decodePoint(baseEncoding);
                return new ECParameterSpec((ECCurve)curve, base, order, cofactor);
            }
            case 2: {
                ECCurve.F2m curve;
                int m = ECDHParams.getInt16From(input);
                ECDHParams.putInt16To(out, m);
                short basis = (short)ECDHParams.getInt8From(input);
                ECDHParams.putInt8To(out, basis);
                if (!ECBasisType.isValid(basis)) {
                    throw new SSLHandshakeException("Invalid ECParameter: ECBasisType=" + basis);
                }
                int k1 = ECDHParams.readECExponent(out, m, input);
                int k2 = -1;
                int k3 = -1;
                if (basis == 2) {
                    k2 = ECDHParams.readECExponent(out, m, input);
                    k3 = ECDHParams.readECExponent(out, m, input);
                }
                BigInteger a = ECDHParams.readECFieldElement(out, m, input);
                BigInteger b = ECDHParams.readECFieldElement(out, m, input);
                byte[] baseEncoding = ECDHParams.getBytes8From(input);
                ECDHParams.putBytes8To(out, baseEncoding);
                BigInteger order = ECDHParams.readECParameter(out, input);
                BigInteger cofactor = ECDHParams.readECParameter(out, input);
                ECCurve.F2m f2m = curve = basis == 2 ? new ECCurve.F2m(m, k1, k2, k3, a, b, order, cofactor) : new ECCurve.F2m(m, k1, a, b, order, cofactor);
                if (baseEncoding == null || baseEncoding.length < 1) {
                    throw new SSLHandshakeException("Invalid ECParameter: encoding");
                }
                ECPoint base = curve.decodePoint(baseEncoding);
                return new ECParameterSpec((ECCurve)curve, base, order, cofactor);
            }
            case 3: {
                int namedCurve = ECDHParams.getInt16From(input);
                ECDHParams.putInt16To(out, namedCurve);
                return ECDHParams.getParametersForNamedCurve(namedCurve);
            }
        }
        throw new SSLHandshakeException("Unsupported ECCurveType: " + curveType);
    }

    static final int readECExponent(OutputStream out, int fieldSize, InputStream input) throws IOException {
        int k;
        BigInteger K = ECDHParams.readECParameter(out, input);
        if (K.bitLength() < 32 && (k = K.intValue()) > 0 && k < fieldSize) {
            return k;
        }
        throw new SSLHandshakeException("Invalid ECParameter: fieldSize=" + fieldSize);
    }

    static final BigInteger readECFieldElement(OutputStream out, int fieldSize, InputStream input) throws IOException {
        int requiredLength = (fieldSize + 7) / 8;
        byte[] encoding = ECDHParams.getBytes8From(input);
        if (encoding.length != requiredLength) {
            throw new SSLHandshakeException("Invalid ECParameter: fieldSize=" + fieldSize);
        }
        out.write(encoding.length);
        out.write(encoding, 0, encoding.length);
        return new BigInteger(1, encoding);
    }

    static final BigInteger readECParameter(OutputStream out, InputStream input) throws IOException {
        byte[] bytes = ECDHParams.getBytes8From(input);
        if (bytes.length == 0) {
            throw new SSLHandshakeException("Invalid ECParameter: BigInteger opaqueLength = 0");
        }
        out.write(bytes.length);
        out.write(bytes, 0, bytes.length);
        return new BigInteger(1, bytes);
    }

    static final ECParameterSpec getParametersForNamedCurve(int namedCurve) {
        X9ECParameters ecP = SECNamedCurves.getByName((String)"sm2");
        if (ecP == null) {
            return null;
        }
        return new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH());
    }

    public static final void writeECParameters(OutputStream out, int curveType, ECParameterSpec ecParameters) throws IOException {
        switch (curveType) {
            case 1: {
                ECCurve curve = ecParameters.getCurve();
                ECDHParams.putInt8To(out, 1);
                ECDHParams.writeECParameter(out, curve.getField().getCharacteristic());
                ECDHParams.writeECFieldElement(out, curve.getA());
                ECDHParams.writeECFieldElement(out, curve.getB());
                ECDHParams.writeECPoint(out, ecParameters.getG());
                ECDHParams.writeECParameter(out, ecParameters.getN());
                ECDHParams.writeECParameter(out, ecParameters.getH());
                break;
            }
            case 3: {
                int curveId = SupportedEllipticCurvesExtension.getCurveIndex(ecParameters);
                ECDHParams.putInt8To(out, 3);
                ECDHParams.putInt16To(out, curveId);
            }
        }
    }

    static final void writeECParameter(OutputStream out, BigInteger x) throws IOException {
        ECDHParams.putBytes8To(out, BigIntegers.asUnsignedByteArray((BigInteger)x));
    }

    static final void writeECPoint(OutputStream out, ECPoint point) throws IOException {
        ECPoint normed = point.normalize();
        byte[] X = normed.getXCoord().getEncoded();
        byte[] Y = normed.getYCoord().getEncoded();
        byte[] publicQ = new byte[1 + X.length + Y.length];
        publicQ[0] = 4;
        System.arraycopy(X, 0, publicQ, 1, X.length);
        System.arraycopy(Y, 0, publicQ, X.length + 1, Y.length);
        ECDHParams.putBytes8To(out, publicQ);
    }

    static final void writeECFieldElement(OutputStream out, ECFieldElement x) throws IOException {
        ECDHParams.putBytes8To(out, x.getEncoded());
    }

    public static final void putInt8To(OutputStream out, int length) throws IOException {
        out.write(length);
    }

    public static final void putInt16To(OutputStream out, int length) throws IOException {
        out.write(length >> 8);
        out.write(length);
    }

    public static final void putInt24To(OutputStream out, int length) throws IOException {
        out.write(length >> 16);
        out.write(length >> 8);
        out.write(length);
    }

    public static final void putInt32To(OutputStream out, int length) throws IOException {
        out.write(length >> 24);
        out.write(length >> 16);
        out.write(length >> 8);
        out.write(length);
    }

    public static final void putBytes8To(OutputStream out, byte[] value) throws IOException {
        if (value == null) {
            ECDHParams.putInt8To(out, 0);
            return;
        }
        ECDHParams.putInt8To(out, value.length);
        out.write(value, 0, value.length);
    }

    public static final void putBytes16To(OutputStream out, byte[] value) throws IOException {
        if (value == null) {
            ECDHParams.putInt16To(out, 0);
            return;
        }
        ECDHParams.putInt16To(out, value.length);
        out.write(value, 0, value.length);
    }

    public static final void putBytes24To(OutputStream out, byte[] value) throws IOException {
        if (value == null) {
            ECDHParams.putInt24To(out, 0);
            return;
        }
        ECDHParams.putInt24To(out, value.length);
        out.write(value, 0, value.length);
    }

    public static final int getInt8From(InputStream input) throws IOException {
        return input.read();
    }

    public static final int getInt16From(InputStream input) throws IOException {
        return input.read() << 8 | input.read();
    }

    public static final int getInt24From(InputStream input) throws IOException {
        return input.read() << 16 | input.read() << 8 | input.read();
    }

    public static final int getInt32From(InputStream input) throws IOException {
        return input.read() << 24 | input.read() << 16 | input.read() << 8 | input.read();
    }

    public static final byte[] getBytes8From(InputStream input) throws IOException {
        int len = ECDHParams.getInt8From(input);
        ECDHParams.verifyLengthFrom(input, len);
        byte[] value = new byte[len];
        input.read(value, 0, len);
        return value;
    }

    public static final byte[] getBytes16From(InputStream input) throws IOException {
        int len = ECDHParams.getInt16From(input);
        ECDHParams.verifyLengthFrom(input, len);
        byte[] value = new byte[len];
        input.read(value, 0, len);
        return value;
    }

    public static final byte[] getBytes24From(InputStream input) throws IOException {
        int len = ECDHParams.getInt24From(input);
        ECDHParams.verifyLengthFrom(input, len);
        byte[] value = new byte[len];
        input.read(value, 0, len);
        return value;
    }

    static final void verifyLengthFrom(InputStream input, int len) throws IOException {
        if (len > input.available()) {
            throw new SSLException("Not enough data to fill declared vector size");
        }
    }

    public static byte[] getECParametersBytes(ECParameterSpec ecParameters, int curveType) {
        byte[] encoded = null;
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(1024);
            ECDHParams.writeECParameters(out, curveType, ecParameters);
            encoded = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not encode ecParameters", e);
        }
        finally {
            out = null;
        }
        return encoded;
    }
}

