/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.crypto.ec.CustomNamedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.tls.util.Utilities;
import java.io.IOException;

public final class ECNamedCurve {
    public static final int sm2 = 64;
    public static final int arbitrary_explicit_prime_curves = 65281;
    public static final int arbitrary_explicit_char2_curves = 65282;

    private ECNamedCurve() {
    }

    public static final boolean isValid(int namedCurve) {
        return namedCurve == 64 || namedCurve == 65281 || namedCurve == 65282;
    }

    public static final boolean refersToASpecificNamedCurve(int namedCurve) {
        switch (namedCurve) {
            case 65281: 
            case 65282: {
                return false;
            }
        }
        return true;
    }

    public static final X9ECParameters getByName(String name) {
        return SECNamedCurves.getByName((String)name);
    }

    public static final X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
    }

    public static final ASN1ObjectIdentifier getOID(String name) {
        return SECNamedCurves.getOID((String)name);
    }

    public static final String getName(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getName((ASN1ObjectIdentifier)oid);
    }

    public static final String getNamedCurveOid(ECParameterSpec params) {
        String namedCurveOid = null;
        if (params == null) {
            namedCurveOid = null;
        } else {
            ASN1ObjectIdentifier oid;
            String curveName = "sm2";
            int fieldSize = 256;
            X9ECParameters parameters = SECNamedCurves.getByName((String)curveName);
            boolean match = ECNamedCurve.checkECParams(parameters, params, fieldSize);
            if (match && (oid = SECNamedCurves.getOID((String)curveName)) != null) {
                namedCurveOid = oid.getId();
            }
        }
        return namedCurveOid;
    }

    private static final boolean checkECParams(X9ECParameters parameters, ECParameterSpec params, int fieldSize) {
        boolean checkResult = true;
        if (parameters == null || params == null) {
            checkResult = false;
        } else if (parameters.getCurve().getFieldSize() != fieldSize) {
            checkResult = false;
        } else if (!parameters.getCurve().equals(params.getCurve())) {
            checkResult = false;
        } else if (!parameters.getG().equals(params.getG())) {
            checkResult = false;
        } else if (!parameters.getN().equals(params.getN())) {
            checkResult = false;
        } else if (!parameters.getH().equals(params.getH())) {
            checkResult = false;
        }
        return checkResult;
    }

    public static final ECParameterSpec getECParameterSpec(String namedCurveOid) {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(namedCurveOid);
        X9ECParameters ecP = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)oid);
        ECNamedCurveParameterSpec ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        return ecSpec;
    }

    public static final ECPoint decodePoint(byte[] encoded, ECCurve curve) throws IOException {
        return curve.decodePoint(encoded);
    }

    public static final byte[] encodePoint(ECPoint point, ECCurve curve) {
        int n = curve.getFieldSize() + 7 >> 3;
        byte[] xb = ECNamedCurve.trimZeroes(point.getAffineXCoord().getEncoded());
        byte[] yb = ECNamedCurve.trimZeroes(point.getAffineYCoord().getEncoded());
        if (xb.length > n || yb.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    public static boolean isSM2NamedCurve(ECParameterSpec params) {
        if (params == null) {
            return false;
        }
        X9ECParameters parameters = SECNamedCurves.getByName((String)"sm2");
        if (parameters == null) {
            return false;
        }
        if (params.getCurve() == null) {
            return false;
        }
        int fieldSize = params.getCurve().getFieldSize();
        if (parameters.getCurve().getFieldSize() != fieldSize) {
            return false;
        }
        if (!parameters.getCurve().equals(params.getCurve())) {
            return false;
        }
        if (!parameters.getG().equals(params.getG())) {
            return false;
        }
        if (!parameters.getN().equals(params.getN())) {
            return false;
        }
        return parameters.getH().equals(params.getH());
    }

    private static final byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        return Utilities.copyOfRange(b, i, b.length);
    }

    public static void test(String[] args) {
        String namedCurveOid = "1.2.840.10045.3.1.7";
        System.err.println(ECNamedCurve.getECParameterSpec("1.2.840.10045.3.1.7"));
        X9ECParameters xxx = null;
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier("1.2.840.10045.3.1.7");
        xxx = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
        System.err.println(xxx);
    }
}

