/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCryptoPrimitive;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class SignatureAndHashAlgorithm {
    static final int SUPPORTED_ALG_PRIORITY_MAX_NUM = 240;
    private static final Set<GMCryptoPrimitive> SIGNATURE_PRIMITIVE_SET = EnumSet.of(GMCryptoPrimitive.SIGNATURE);
    private static final Map<Integer, SignatureAndHashAlgorithm> supportedMap = Collections.synchronizedSortedMap(new TreeMap());
    private static final Map<Integer, SignatureAndHashAlgorithm> priorityMap = Collections.synchronizedSortedMap(new TreeMap());
    private HashAlgorithm hash;
    private int id;
    private String algorithm;
    private int priority;

    private SignatureAndHashAlgorithm(HashAlgorithm hash, SignatureAlgorithm signature, String algorithm, int priority) {
        this.hash = hash;
        this.algorithm = algorithm;
        this.id = (hash.value & 0xFF) << 8 | signature.value & 0xFF;
        this.priority = priority;
    }

    private SignatureAndHashAlgorithm(String algorithm, int id, int sequence) {
        this.hash = HashAlgorithm.valueOf(id >> 8 & 0xFF);
        this.algorithm = algorithm;
        this.id = id;
        this.priority = 240 + sequence + 1;
    }

    public static SignatureAndHashAlgorithm valueOf(int hash, int signature, int sequence) {
        int id = (hash &= 0xFF) << 8 | (signature &= 0xFF);
        SignatureAndHashAlgorithm signAlg = supportedMap.get(id);
        if (signAlg == null) {
            signAlg = new SignatureAndHashAlgorithm("Unknown (hash:0x" + Integer.toString(hash, 16) + ", signature:0x" + Integer.toString(signature, 16) + ")", id, sequence);
        }
        return signAlg;
    }

    public int getHashValue() {
        return this.id >> 8 & 0xFF;
    }

    public int getSignatureValue() {
        return this.id & 0xFF;
    }

    public String getAlgorithmName() {
        return this.algorithm;
    }

    public static int sizeInRecord() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SignatureAndHashAlgorithm> getSupportedAlgorithms(GMAlgorithmConstraints constraints) {
        ArrayList<SignatureAndHashAlgorithm> supported = new ArrayList<SignatureAndHashAlgorithm>();
        Map<Integer, SignatureAndHashAlgorithm> map = priorityMap;
        synchronized (map) {
            for (SignatureAndHashAlgorithm sigAlg : priorityMap.values()) {
                if (sigAlg.priority > 240 || !constraints.permits(SIGNATURE_PRIMITIVE_SET, sigAlg.algorithm, null)) continue;
                supported.add(sigAlg);
            }
        }
        return supported;
    }

    public static List<SignatureAndHashAlgorithm> getSupportedAlgorithms(Collection<SignatureAndHashAlgorithm> algorithms) {
        ArrayList<SignatureAndHashAlgorithm> supported = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm sigAlg : algorithms) {
            if (sigAlg.priority > 240) continue;
            supported.add(sigAlg);
        }
        return supported;
    }

    public static String[] getAlgorithmNames(Collection<SignatureAndHashAlgorithm> algorithms) {
        ArrayList<String> algorithmNames = new ArrayList<String>();
        if (algorithms != null) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                algorithmNames.add(sigAlg.algorithm);
            }
        }
        String[] array = new String[algorithmNames.size()];
        return algorithmNames.toArray(array);
    }

    public static Set<String> getHashAlgorithmNames(Collection<SignatureAndHashAlgorithm> algorithms) {
        HashSet<String> algorithmNames = new HashSet<String>();
        if (algorithms != null) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                if (sigAlg.hash.value <= 0) continue;
                algorithmNames.add(sigAlg.hash.standardName);
            }
        }
        return algorithmNames;
    }

    public static String getHashAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return algorithm.hash.standardName;
    }

    private static void supports(HashAlgorithm hash, SignatureAlgorithm signature, String algorithm, int priority) {
        SignatureAndHashAlgorithm pair = new SignatureAndHashAlgorithm(hash, signature, algorithm, priority);
        if (supportedMap.put(pair.id, pair) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, id: " + pair.id);
        }
        if (priorityMap.put(pair.priority, pair) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, priority: " + pair.priority);
        }
    }

    public static SignatureAndHashAlgorithm getPreferableAlgorithm(List<SignatureAndHashAlgorithm> algorithms, String expected) {
        return SignatureAndHashAlgorithm.getPreferableAlgorithm(algorithms, expected, null);
    }

    public static SignatureAndHashAlgorithm getPreferableAlgorithm(List<SignatureAndHashAlgorithm> algorithms, String expected, PrivateKey signingKey) {
        if (expected == null && !algorithms.isEmpty()) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                if (sigAlg.priority > 240) continue;
                return sigAlg;
            }
            return null;
        }
        if (expected == null) {
            return null;
        }
        for (SignatureAndHashAlgorithm algorithm : algorithms) {
            int signValue = algorithm.id & 0xFF;
            if (!expected.equalsIgnoreCase("sm2") || signValue != SignatureAlgorithm.SM2.value) continue;
            return algorithm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Integer, SignatureAndHashAlgorithm> map = supportedMap;
        synchronized (map) {
            int p = 240;
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SM3, SignatureAlgorithm.SM2, "SM3withSM2", --p);
        }
    }

    public static enum SignatureAlgorithm {
        UNDEFINED("undefined", -1),
        ANONYMOUS("anonymous", 0),
        SM2("sm2", 4);

        final String name;
        public final int value;

        private SignatureAlgorithm(String name, int value) {
            this.name = name;
            this.value = value;
        }

        static SignatureAlgorithm valueOf(int value) {
            SignatureAlgorithm algorithm = UNDEFINED;
            switch (value) {
                case 0: {
                    algorithm = ANONYMOUS;
                    break;
                }
                case 4: {
                    algorithm = SM2;
                }
            }
            return algorithm;
        }
    }

    public static enum HashAlgorithm {
        UNDEFINED("undefined", "", -1, -1),
        NONE("none", "NONE", 0, -1),
        SM3("sm3", "SM3", 7, 32);

        final String name;
        final String standardName;
        public final int value;
        final int length;

        private HashAlgorithm(String name, String standardName, int value, int length) {
            this.name = name;
            this.standardName = standardName;
            this.value = value;
            this.length = length;
        }

        static HashAlgorithm valueOf(int value) {
            HashAlgorithm algorithm = UNDEFINED;
            switch (value) {
                case 0: {
                    algorithm = NONE;
                    break;
                }
                case 7: {
                    algorithm = SM3;
                    break;
                }
                default: {
                    algorithm = UNDEFINED;
                }
            }
            return algorithm;
        }
    }
}

