/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api;

import com.bocom.api.BocomApiException;
import com.bocom.api.BocomClient;
import com.bocom.api.BocomDownloadEncryptRequest;
import com.bocom.api.BocomDownloadRequest;
import com.bocom.api.BocomEncryptRequest;
import com.bocom.api.BocomRequest;
import com.bocom.api.BocomResponse;
import com.bocom.api.BocomUploadEncryptRequest;
import com.bocom.api.BocomUploadRequest;
import com.bocom.api.extInfo.ExtraInfoBase;
import com.bocom.api.security.spi.SignatureSpi;
import com.bocom.api.security.spi.impl.NormalLevelSignApi;
import com.bocom.api.utils.BocomDigest;
import com.bocom.api.utils.BocomEncrypt;
import com.bocom.api.utils.BocomHashMap;
import com.bocom.api.utils.BocomSignature;
import com.bocom.api.utils.FileItem;
import com.bocom.api.utils.StringUtils;
import com.bocom.api.utils.WebUtils;
import com.bocom.api.utils.enums.EncryptPolicy;
import com.bocom.api.utils.enums.EncryptType;
import com.bocom.api.utils.enums.SecurityLevel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBocomClient
implements BocomClient {
    protected String appId;
    protected SignatureSpi highLevelSignApi;
    protected SignatureSpi normalSignApi;
    protected String charset = "UTF-8";
    protected String format = "json";
    protected String bocomPublicKey;
    private String zoneNo = null;
    private int connectTimeout = 50000;
    private int readTimeout = 50000;
    private String proxyIp = null;
    private int proxyPort = 0;
    private String encryptKey = null;
    private EncryptType encryptType = EncryptType.RSA_AND_AES;
    private EncryptPolicy encryptPolicy = null;
    private ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger logger = LoggerFactory.getLogger(DefaultBocomClient.class);

    public DefaultBocomClient(String appId, String privateKey, String charset, String format, String bocomPublicKey) {
        this.appId = appId;
        this.normalSignApi = new NormalLevelSignApi(privateKey);
        this.charset = charset;
        this.format = format;
        this.bocomPublicKey = bocomPublicKey;
        if (bocomPublicKey.startsWith("04")) {
            this.encryptType = EncryptType.SM2_AND_SM4;
        }
    }

    public DefaultBocomClient(String appId, String privateKey, String charset, String format, String bocomPublicKey, EncryptType encryptType, String encryptKey) {
        this.appId = appId;
        this.charset = charset;
        this.format = format;
        this.bocomPublicKey = bocomPublicKey;
        this.encryptType = encryptType;
        this.encryptKey = encryptKey;
        this.normalSignApi = new NormalLevelSignApi(privateKey);
    }

    public DefaultBocomClient(String appId, SignatureSpi highLevelSignApi, String privateKey, String charset, String format, String bocomPublicKey, EncryptType encryptType) {
        this.appId = appId;
        this.charset = charset;
        this.format = format;
        this.bocomPublicKey = bocomPublicKey;
        this.encryptType = encryptType;
        this.highLevelSignApi = highLevelSignApi;
        this.normalSignApi = new NormalLevelSignApi(privateKey);
        if (bocomPublicKey.startsWith("04")) {
            this.encryptType = EncryptType.SM2_AND_SM4;
        }
    }

    public DefaultBocomClient(String appId, SignatureSpi signApi, String charset, String format, String bocomPublicKey, EncryptType encryptType) {
        this.appId = appId;
        this.charset = charset;
        this.format = format;
        this.bocomPublicKey = bocomPublicKey;
        this.encryptType = encryptType;
        this.highLevelSignApi = signApi;
        this.normalSignApi = signApi;
        if (bocomPublicKey.startsWith("04")) {
            this.encryptType = EncryptType.SM2_AND_SM4;
        }
    }

    public DefaultBocomClient(String appId, String privateKey, String bocomPublicKey) {
        this(appId, privateKey, "UTF-8", "json", bocomPublicKey);
    }

    public DefaultBocomClient(String appId, SignatureSpi highLevelSignApi, String privateKey, String bocomPublicKey) {
        this(appId, highLevelSignApi, privateKey, "UTF-8", "json", bocomPublicKey, EncryptType.RSA_AND_AES);
    }

    public DefaultBocomClient(String appId, SignatureSpi signApi, String bocomPublicKey) {
        this(appId, signApi, "UTF-8", "json", bocomPublicKey, EncryptType.RSA_AND_AES);
    }

    public DefaultBocomClient(String appId, String privateKey, String bocomPublicKey, EncryptType encryptType) {
        this(appId, privateKey, "UTF-8", "json", bocomPublicKey);
        this.encryptType = encryptType;
    }

    @Override
    public <T extends BocomResponse> T execute(BocomRequest<T> request) throws BocomApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.execute(request, msgId, "");
    }

    @Override
    public <T extends BocomResponse> T execute(BocomRequest<T> request, String msgId) throws BocomApiException {
        return this.execute(request, msgId, "");
    }

    @Override
    public <T extends BocomResponse> T execute(BocomRequest<T> request, String msgId, String appAuthToken) throws BocomApiException {
        if (request.isNeedEncrypt() & request instanceof BocomEncryptRequest) {
            this.encryptKey = ((BocomEncryptRequest)request).getEncryptKey();
            this.encryptPolicy = ((BocomEncryptRequest)request).getEncryptPolicy();
            this.encryptType = ((BocomEncryptRequest)request).getEncryptType();
        }
        BocomHashMap params = null;
        try {
            params = this.prepareParams(request, msgId, appAuthToken, this.encryptType, this.encryptKey, this.encryptPolicy);
        }
        catch (Exception e) {
            throw new BocomApiException("prepare paramaters in DefaultBocomClient failed", e);
        }
        String respStr = null;
        if ("POST".equals(request.getMethod())) {
            try {
                HashMap<String, FileItem> map;
                if (request instanceof BocomUploadRequest) {
                    map = new HashMap<String, FileItem>();
                    map.put("file_content", ((BocomUploadRequest)request).getFileItem());
                    respStr = WebUtils.doPost(request.getServiceUrl(), params, map, this.charset, this.getConnectTimeout(), this.getReadTimeout(), this.proxyIp, this.proxyPort);
                }
                if (request instanceof BocomUploadEncryptRequest) {
                    map = new HashMap();
                    map.put("file_content", ((BocomUploadEncryptRequest)request).getFileItem());
                    respStr = WebUtils.doPost(request.getServiceUrl(), params, map, this.charset, this.getConnectTimeout(), this.getReadTimeout(), this.proxyIp, this.proxyPort);
                }
                if (request instanceof BocomDownloadRequest) {
                    respStr = WebUtils.doPost(request.getServiceUrl(), params, ((BocomDownloadRequest)request).getDownloadPath(), "rsp_biz_content", this.charset, this.connectTimeout, this.readTimeout, this.proxyIp, this.proxyPort);
                }
                if (request instanceof BocomDownloadEncryptRequest) {
                    respStr = WebUtils.doPost(request.getServiceUrl(), params, ((BocomDownloadEncryptRequest)request).getDownloadPath(), "rsp_biz_content", this.charset, this.getConnectTimeout(), this.getReadTimeout(), this.proxyIp, this.proxyPort);
                }
                respStr = WebUtils.doPost(request.getServiceUrl(), params, this.charset, this.getConnectTimeout(), this.getReadTimeout(), this.proxyIp, this.proxyPort);
            }
            catch (Exception e) {
                logger.error("api connect host err", (Throwable)e);
                throw new BocomApiException("api connect host err", e);
            }
        } else {
            throw new BocomApiException("only support POST, method: " + request.getMethod());
        }
        T response = this.parse(request, respStr, this.encryptType, this.encryptKey);
        if (response == null) {
            throw new BocomApiException("response is null.");
        }
        return response;
    }

    protected <T extends BocomResponse> T parse(BocomRequest<T> request, String respStr, EncryptType algorithmType, String encryptKey) throws BocomApiException {
        return this.parseJsonWithBocomSign(request, respStr, algorithmType, encryptKey);
    }

    private <T extends BocomResponse> T parseJsonWithBocomSign(BocomRequest<T> request, String respStr, EncryptType algorithmType, String encryptKey) throws BocomApiException {
        EncryptPolicy encryptPolicy;
        String respBizContentStr = null;
        String sign = null;
        try {
            int indexOfRootStart = respStr.indexOf("rsp_biz_content") + "rsp_biz_content".length() + 2;
            int indexOfRootEnd = respStr.lastIndexOf(",");
            int indexOfSignStart = respStr.lastIndexOf("sign\"") + "sign".length() + 3;
            int indexOfSignEnd = respStr.lastIndexOf("\"");
            respBizContentStr = respStr.substring(indexOfRootStart, indexOfRootEnd);
            sign = respStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            logger.error("parse response string error, response string is not bocom json format, response string: " + respStr, (Throwable)e);
            throw new BocomApiException("response is not format bocom json. respStr :\n" + respStr, e);
        }
        boolean passed = BocomSignature.verify(algorithmType, respBizContentStr, this.bocomPublicKey, this.charset, sign);
        if (!passed) {
            logger.error("bizContent verify error, bizContent: {}, bocom public key: {}, signature: {}", new Object[]{respBizContentStr, this.bocomPublicKey, sign});
            throw new BocomApiException("Bocom sign verify not passed.");
        }
        if (request.isNeedEncrypt() && request instanceof BocomEncryptRequest && EncryptPolicy.CONTENT == (encryptPolicy = ((BocomEncryptRequest)request).getEncryptPolicy()) && respBizContentStr != null) {
            try {
                respBizContentStr = BocomEncrypt.symDecryptContent(respBizContentStr.substring(1, respBizContentStr.length() - 1), algorithmType, encryptKey, this.charset);
            }
            catch (RuntimeException e) {
                logger.error("decrypt response error, encrypt key: " + encryptKey);
                throw new BocomApiException("response can not decrypt. response: " + respStr, e);
            }
        }
        try {
            return (T)((BocomResponse)this.objectMapper.readValue(respBizContentStr, request.getResponseClass()));
        }
        catch (Exception e) {
            throw new BocomApiException("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), e);
        }
    }

    protected BocomHashMap prepareParams(BocomRequest<?> request, String msgId, String authToken, EncryptType algorithmType, String encryptKey, EncryptPolicy encryptPolicy) throws Exception {
        String signedStr;
        String path;
        String bizContentStr = this.buildBizContentStr(request);
        try {
            path = new URL(request.getServiceUrl()).getPath();
            if (path.indexOf("/api/") != -1) {
                path = path.substring(path.indexOf("/api/"));
            }
        }
        catch (MalformedURLException e) {
            throw new BocomApiException("url is not valid. url: " + request.getServiceUrl(), e);
        }
        BocomHashMap params = new BocomHashMap();
        Map<String, ExtraInfoBase> extraParams = request.getExtraParameters();
        params.put("app_id", this.appId);
        params.put("charset", this.charset);
        params.put("fmt_type", this.format);
        params.put("auth_token", authToken);
        params.put("msg_id", msgId);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        params.put("timestamp", df.format(new Date(timestamp)));
        if (!request.isNeedEncrypt()) {
            params.put("biz_content", bizContentStr);
        } else {
            if (!StringUtils.areNotEmpty(encryptKey)) {
                throw new BocomApiException("request need be encrypted, encryptPolicy,encrypt type and encrypt key can not be null.");
            }
            params.put("is_encrypt", (Object)request.isNeedEncrypt());
        }
        if (request instanceof BocomUploadRequest) {
            params.put("file_hashcode", BocomDigest.fileDigest(((BocomUploadRequest)request).getFileItem()));
        }
        if (request instanceof BocomEncryptRequest) {
            if (EncryptPolicy.CONTENT == encryptPolicy && bizContentStr != null) {
                params.put("biz_content", BocomEncrypt.symEncryptContent(bizContentStr, algorithmType, encryptKey, this.charset));
            } else {
                params.put("biz_content", bizContentStr);
            }
            params.put("encrypt_key", BocomEncrypt.asyEncryptContent(encryptKey, algorithmType, this.bocomPublicKey, this.charset));
        }
        if (request instanceof BocomUploadEncryptRequest) {
            FileItem f = ((BocomUploadEncryptRequest)request).getFileItem();
            params.put("file_hashcode", BocomDigest.fileDigest(f));
            BocomEncrypt.takeEncryptFile(f, algorithmType, encryptKey);
        }
        if (extraParams != null && extraParams.size() > 0) {
            params.put("ext_info", this.objectMapper.writeValueAsString(extraParams));
        }
        String strToSign = WebUtils.buildOrderedSignStr(path, params);
        if (this.normalSignApi != null && SecurityLevel.NORMAL == request.getSecurityLevel()) {
            signedStr = this.normalSignApi.sign(strToSign);
        } else if (this.highLevelSignApi != null && SecurityLevel.HIGH == request.getSecurityLevel()) {
            signedStr = this.highLevelSignApi.sign(strToSign);
        } else {
            throw new BocomApiException("no signature implementation found!!!");
        }
        params.put("sign", signedStr);
        return params;
    }

    protected String buildBizContentStr(BocomRequest<?> request) throws BocomApiException {
        if (request.getBizContent() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            try {
                return this.objectMapper.writeValueAsString((Object)request.getBizContent());
            }
            catch (JsonProcessingException e) {
                throw new BocomApiException("request.getBizContent() format to Json  error", e);
            }
        }
        throw new BocomApiException("only support json format, current format is not supported. format: " + this.format);
    }

    public void ignoreSSLHostnameVerifier() {
        WebUtils.ignoreSSLHostnameVerifier();
    }

    public void setEncryptType(EncryptType type) {
        this.encryptType = type;
    }

    public String getZoneNo() {
        return this.zoneNo;
    }

    public void setZoneNo(String zoneNo) {
        this.zoneNo = zoneNo;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxy(String proxyIp, int proxyPort) {
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
    }

    public void setHighLevelSignApi(SignatureSpi highLevelSignApi) {
        this.highLevelSignApi = highLevelSignApi;
    }

    public void setNormalSignApi(SignatureSpi normalSignApi) {
        this.normalSignApi = normalSignApi;
    }
}

