/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.crypt.impl;

import com.bocom.api.security.crypt.ApiCryptor;
import com.bocom.api.utils.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class AESCryptor
implements ApiCryptor {
    @Override
    public String encrypt(String sourceContent, String cryptKey, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(cryptKey));
            byte[] bytes = sourceContent.getBytes(charset);
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            cipher.doFinal(output, len);
            return Base64.encode(output);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] content, String aesKey, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(aesKey));
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(content.length)];
            int len = cipher.processBytes(content, 0, content.length, output, 0);
            cipher.doFinal(output, len);
            return Base64.decode(Base64.encode(output));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String encryptContent, String cryptKey, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(cryptKey));
            byte[] bytes = Base64.decode(encryptContent);
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(false, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            int len2 = cipher.doFinal(output, len);
            byte[] rawData = new byte[len + len2];
            System.arraycopy(output, 0, rawData, 0, rawData.length);
            String plainData = new String(rawData, Charset.forName(charset));
            return plainData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(byte[] content, String aesKey, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(aesKey));
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(false, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(content.length)];
            int len = cipher.processBytes(content, 0, content.length, output, 0);
            int len2 = cipher.doFinal(output, len);
            byte[] rawData = new byte[len + len2];
            System.arraycopy(output, 0, rawData, 0, rawData.length);
            String plainData = new String(rawData, Charset.forName(charset));
            return plainData.getBytes(charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ByteArrayOutputStream encryptFile(InputStream in, String cryptKey) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(cryptKey));
            byte[] bytes = AESCryptor.toByteArray(in);
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            cipher.doFinal(output, len);
            baos.write(output);
            baos.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e1) {
                throw new RuntimeException("encryptFile inputStream close error", e1);
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("encryptFile byteArrayOutputStream close error", e);
            }
        }
        return baos;
    }

    public ByteArrayOutputStream decryptFile(InputStream in, String cryptKey) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(cryptKey));
            byte[] bytes = AESCryptor.toByteArray(in);
            CBCBlockCipher aes = new CBCBlockCipher((BlockCipher)new AESEngine());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aes, (BlockCipherPadding)new PKCS7Padding());
            cipher.init(false, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            int len2 = cipher.doFinal(output, len);
            byte[] rawData = new byte[len + len2];
            System.arraycopy(output, 0, rawData, 0, rawData.length);
            baos.write(rawData);
            baos.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e1) {
                throw new RuntimeException("decryptFile inputStream close error", e1);
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("decryptFile byteArrayOutputStream close error", e);
            }
        }
        return baos;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

