/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.crypt.impl;

import com.bocom.api.security.crypt.ApiCryptor;
import com.bocom.api.utils.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSACryptor
implements ApiCryptor {
    public static final String RSA_ALGORITHM = "RSA";
    public static final String CHARSET = "UTF-8";

    @Override
    public String encrypt(String data, String publicKey, String chaset) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decode(publicKey));
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, rsaPublicKey);
            return Base64.encode(RSACryptor.rsaSplitCodec(cipher, 1, data.getBytes(chaset), rsaPublicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    @Override
    public String decrypt(String data, String privateKey, String chaset) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, rsaPrivateKey);
            return new String(RSACryptor.rsaSplitCodec(cipher, 2, Base64.decode(data), rsaPrivateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5b57\u8282\u6d41\u5173\u95ed\u5f02\u5e38", e);
        }
        return resultDatas;
    }

    public static void main(String[] args) {
        String privateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCBqsY+TaOClwLGK5SAmZsjT8zW69LLKbt+Six5qK0lsUwXyM7E0ErrPRmNvpATIYQcSjBS8Ci5fh3cw2aHtmS5Vvj1Hq8l4Sw8/+ZOe4JKrAHuHF2g/Ma5osn3NfEMTWeSKzu+2P+4zlwWGoCm2OyzR44LQfKz5+Qnh6S4kDNTodwPazFonh9EVJ42dSX/ILtSQHRkYmAOJ78dx86YX8Nub+qTdnuciWLq62tEfbUBv7Ic15uwYwLfR1nIomWg/4dhMGhmibMxg8vWKZ7kghlj02D8yVEy3/xzbe4yMNdiWwWK3TbfOWufYfqUTqlXOkDoLiA+R025Udrkel6gHYOZAgMBAAECggEAGbkQFMIAIuLkOP3iOtS+EvY8s5IawhToTfhW9FeC6cxPRRSf+Ck+A4aecCESocjvVVFeXsWnvoyHTgkxaNDFEINxZecNZd1SklNNk9oqkbentl3IMSyUG7VwjWsVA5TDbBrJgmW37Sh62iOty+uSoUobop4VkJz7BOCCy95HYFqbN3jQOuDNqcEosKkGAdqRGZWZauzn4xGi5nrIoHtS40x/WXa07YAvz9DRlG9xCEgMbCir724zJqYqmHI5p0q91sxBPrUryeFM1SqZAlmM//AV6MbuG6tu5QDcxYUI+a+YS3olrbkdexip6GkKZQh02Hj6ml3wg7JoSXjNLfGQVQKBgQD1J8E6a4fNnNnaApMMk4MGuz0iGc+P+G57/Ca5UFNhRDBT5cAgnQg/LvFy0+0gqzY6VCVW3sv+xkD846pdpK8vvQuarmNZKIw9ZDB97M6VnEzDJ6/UJHqat/drw6ApiTiGsdqrSLUZx3t7fuyXqxMlARmWNy8CqDYbA3vW42lozwKBgQCHZy5P/0CkvQZYf2IiqGPk6HrOHcpOIEmOlY4eaalZ5v8q0CuMH1ylehQhue6nIOXNyg2c0JpK/NJGobp0xF1Q5XTOctmHNGc1eRe+l+oIHJGWWkWE9cqj8Z4NlEbeRflmtJLB7+W+6BBMxaf0m39Oc0g53BRbfwEWqJkcHL2XFwKBgAY8W6Ljx1GIktYDyL/CJMwQCS8L3wa3d//5WvbNv0EzHdOUfX2W4PXSeNvF3js9f6SeLVD3W9MAMfj8xYGaRcZ+FYR6uRY0fNS27rDVTC/sCNvR75wCzYeP9GAuWq2TyvdKINjIgarFMzPh95yoAlWnoIH8p1p28uFfBlBh+nVrAoGAK5oeX8RinKoCER10DJUNFfmHEjilnOLozPF8Am8kCb9JDBBc9ZJj0yWste+Z2lfNqKcYGxdRmDQxwmzyDgftxM8e/hwd0FwfoCiObOGei14nw7LuEBLWXlTAAL9u0sTVuy0K1UjbQs6X8SD1JN+t7yVQbNFh/NS5FQLVyye2JaECgYBSTzKhNWsE77ref9Ibfjg76DLDAz9EWBEmjyNdCPBsK7MpcjtF4jzf4LJoF3G7ygSi7dYwEUUvtNvl8n3qBvtA0jt2G6hJ1kYmYSv7rG4eMQgJ4qCct4UKxdZx7xi6SkT+pIpcsmWCv17eN+4jFKHjA4KAeBOU+2pOzQfAkJjGIw==";
        String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgarGPk2jgpcCxiuUgJmbI0/M1uvSyym7fkoseaitJbFMF8jOxNBK6z0Zjb6QEyGEHEowUvAouX4d3MNmh7ZkuVb49R6vJeEsPP/mTnuCSqwB7hxdoPzGuaLJ9zXxDE1nkis7vtj/uM5cFhqAptjss0eOC0Hys+fkJ4ekuJAzU6HcD2sxaJ4fRFSeNnUl/yC7UkB0ZGJgDie/HcfOmF/Dbm/qk3Z7nIli6utrRH21Ab+yHNebsGMC30dZyKJloP+HYTBoZomzMYPL1ime5IIZY9Ng/MlRMt/8c23uMjDXYlsFit023zlrn2H6lE6pVzpA6C4gPkdNuVHa5HpeoB2DmQIDAQAB";
        String origin = "\u624b\u673a\u53f7,mobileNo,string,Y";
        RSACryptor rsaCryptor = new RSACryptor();
        String encodeStr = rsaCryptor.encrypt(origin, publicKey, CHARSET);
        String decodeStr = rsaCryptor.decrypt(encodeStr, privateKey, CHARSET);
        System.out.println(encodeStr + ":" + decodeStr);
    }
}

