/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.digest.impl;

import com.bocom.api.security.digest.ApiDigest;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class SM3Digest
implements ApiDigest {
    private static final int SM3_DIGEST_SIZE = 32;
    public static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public String digest(byte[] message, String algorithm) throws Exception {
        org.bouncycastle.crypto.digests.SM3Digest sm3Digest = new org.bouncycastle.crypto.digests.SM3Digest();
        sm3Digest.update(message, 0, message.length);
        byte[] digestByteArray = new byte[32];
        sm3Digest.doFinal(digestByteArray, 0);
        return SM3Digest.toHexString(digestByteArray);
    }

    @Override
    public String digest(InputStream in, String algorithm) throws Exception {
        int len;
        org.bouncycastle.crypto.digests.SM3Digest sm3Digest = new org.bouncycastle.crypto.digests.SM3Digest();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
        int bufSize = 1024;
        byte[] buffer = new byte[bufSize];
        while ((len = bufferedInputStream.read(buffer, 0, bufSize)) > 0) {
            sm3Digest.update(buffer, 0, len);
        }
        byte[] digestByteArray = new byte[32];
        sm3Digest.doFinal(digestByteArray, 0);
        bufferedInputStream.close();
        return SM3Digest.toHexString(digestByteArray);
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

