/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.keygen;

import com.bocom.api.security.crypt.impl.AESCryptor;
import com.bocom.api.utils.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.UUID;

public class RSAKeyGen {
    private static final String PUBLIC_KEY = "yourname.pub";
    private static final String PRIVATE_KEY = "yourname.pri";
    private static final String WARNNING = "failed to generate key.";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final int LINE_SIZE = 65;
    private static final String NEW_LINE_STR = System.getProperty("line.separator");
    private static final byte[] NEW_LINE_BYTES = NEW_LINE_STR.getBytes();
    private static final byte[] START_PUBLIC_KEY_BYTES = "##############start public key##############".getBytes();
    private static final byte[] END_PUBLIC_KEY_BYTES = "##############end public key##############".getBytes();
    private static final byte[] START_PRIVATE_KEY_BYTES = "##############start private key##############".getBytes();
    private static final byte[] END_PRIVATE_KEY_BYTES = "##############end private key##############".getBytes();
    private static final String GENERATR_ALG = "key generate algorithm: ";

    public static void main(String[] args) throws Exception {
        try {
            FileOutputStream priOs = new FileOutputStream(PRIVATE_KEY);
            FileOutputStream pubOs = new FileOutputStream(PUBLIC_KEY);
            if (args.length == 1) {
                int keySize = Integer.parseInt(args[0]);
                RSAKeyGen.genRsaWithoutNewline(keySize, priOs, pubOs);
            } else {
                RSAKeyGen.genRsaWithoutNewline(2048, priOs, pubOs);
            }
        }
        catch (Exception e) {
            throw new Exception(WARNNING, e);
        }
    }

    public static KeyPair generateKeyPair() throws Exception {
        return RSAKeyGen.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keysize, new SecureRandom(UUID.randomUUID().toString().getBytes()));
        return keyPairGenerator.generateKeyPair();
    }

    public static void generateRsa(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream) throws Exception {
        RSAKeyGen.generateRsa(priKeyOutputStream, pubKeyOutputStream, null);
    }

    public static void generateRsa(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, String password) throws Exception {
        RSAKeyGen.saveKeys(priKeyOutputStream, pubKeyOutputStream, RSAKeyGen.generateKeyPair(), password);
    }

    public static void genRsaWithoutNewline(int keysize, OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream) throws Exception {
        RSAKeyGen.genRsaWithoutNewline(keysize, priKeyOutputStream, pubKeyOutputStream, null);
    }

    public static void genRsaWithoutNewline(int keysize, OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, String password) throws Exception {
        KeyPair kp = RSAKeyGen.generateKeyPair(keysize);
        RSAKeyGen.savePrivateKeyWithoutNewline(priKeyOutputStream, kp.getPrivate().getEncoded(), password);
        RSAKeyGen.savePublicKeyWithoutNewline(pubKeyOutputStream, kp.getPublic().getEncoded());
    }

    public static String loadPublicKeyFromStream(String filePath) throws Exception {
        return RSAKeyGen.loadApiKeyFromStream(new FileInputStream(filePath), KeyType.PUBLIC_KEY);
    }

    protected static String loadApiKeyFromStream(InputStream in, KeyType keyType) throws Exception {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuffer privateKey = new StringBuffer();
        String line = null;
        boolean firstLine = true;
        boolean containsDesc = false;
        boolean start = false;
        while ((line = rb.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(GENERATR_ALG)) {
                    containsDesc = true;
                }
                firstLine = false;
            }
            if (containsDesc && !start) {
                if (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                    start = true;
                    continue;
                }
                if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                start = true;
                continue;
            }
            if (start && (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
            privateKey.append(line);
        }
        return privateKey.toString().trim();
    }

    public static byte[] loadPublicKeyFromStream(InputStream in) throws Exception {
        return RSAKeyGen.loadKeyFromStream(in, KeyType.PUBLIC_KEY);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream in, String password) throws Exception {
        return new AESCryptor().decrypt(RSAKeyGen.loadKeyFromStream(in, KeyType.PRIVATE_KEY), password, CHARSET_UTF8);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream in) throws Exception {
        return RSAKeyGen.loadKeyFromStream(in, KeyType.PRIVATE_KEY);
    }

    protected static void saveKeys(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, KeyPair kp) throws Exception {
        RSAKeyGen.saveKeys(priKeyOutputStream, pubKeyOutputStream, kp, null);
    }

    protected static void saveKeys(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, KeyPair kp, String password) throws Exception {
        RSAKeyGen.savePrivateKey(priKeyOutputStream, kp.getPrivate().getEncoded(), password);
        RSAKeyGen.savePublicKey(pubKeyOutputStream, kp.getPublic().getEncoded());
    }

    protected static void savePublicKey(OutputStream pubKeyOutputStream, byte[] pubKeyBytes) throws Exception {
        try {
            pubKeyOutputStream.write(RSAKeyGen.getTitle().getBytes(CHARSET_UTF8));
            pubKeyOutputStream.write(NEW_LINE_BYTES);
            pubKeyOutputStream.write(START_PUBLIC_KEY_BYTES);
            pubKeyOutputStream.write(NEW_LINE_BYTES);
            RSAKeyGen.saveBase64KeyToStream(Base64.encodeToByte(pubKeyBytes, false), pubKeyOutputStream);
            pubKeyOutputStream.write(END_PUBLIC_KEY_BYTES);
        }
        finally {
            pubKeyOutputStream.flush();
            pubKeyOutputStream.close();
        }
    }

    protected static void savePrivateKey(OutputStream priKeyOutputStream, byte[] priKeyBytes, String password) throws Exception {
        try {
            if (password != null) {
                priKeyBytes = new AESCryptor().encrypt(priKeyBytes, password, CHARSET_UTF8);
            }
            priKeyOutputStream.write(RSAKeyGen.getTitle().getBytes(CHARSET_UTF8));
            priKeyOutputStream.write(NEW_LINE_BYTES);
            priKeyOutputStream.write(START_PRIVATE_KEY_BYTES);
            priKeyOutputStream.write(NEW_LINE_BYTES);
            RSAKeyGen.saveBase64KeyToStream(Base64.encodeToByte(priKeyBytes, false), priKeyOutputStream);
            priKeyOutputStream.write(END_PRIVATE_KEY_BYTES);
        }
        finally {
            priKeyOutputStream.flush();
            priKeyOutputStream.close();
        }
    }

    protected static void savePublicKeyWithoutNewline(OutputStream pubKeyOutputStream, byte[] pubKeyBytes) throws Exception {
        try {
            pubKeyOutputStream.write(Base64.encodeToByte(pubKeyBytes, false));
        }
        finally {
            pubKeyOutputStream.flush();
            pubKeyOutputStream.close();
        }
    }

    protected static void savePrivateKeyWithoutNewline(OutputStream priKeyOutputStream, byte[] priKeyBytes, String password) throws Exception {
        try {
            if (password != null) {
                priKeyBytes = new AESCryptor().encrypt(priKeyBytes, password, CHARSET_UTF8);
            }
            priKeyOutputStream.write(Base64.encodeToByte(priKeyBytes, false));
        }
        finally {
            priKeyOutputStream.flush();
            priKeyOutputStream.close();
        }
    }

    protected static byte[] loadKeyFromStream(InputStream in, KeyType keyType) throws Exception {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuffer privateKey = new StringBuffer();
        String line = null;
        boolean firstLine = true;
        boolean containsDesc = false;
        boolean start = false;
        while ((line = rb.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(GENERATR_ALG)) {
                    containsDesc = true;
                }
                firstLine = false;
            }
            if (containsDesc && !start) {
                if (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                    start = true;
                    continue;
                }
                if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                start = true;
                continue;
            }
            if (start && (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
            privateKey.append(line);
        }
        return Base64.decode(privateKey.toString());
    }

    protected static void saveBase64KeyToStream(byte[] base64Bytes, OutputStream out) throws IOException {
        int len = 0;
        for (int start = 0; start < base64Bytes.length; start += len) {
            len = Math.min(65, base64Bytes.length - start);
            out.write(base64Bytes, start, len);
            out.write(NEW_LINE_BYTES);
        }
    }

    protected static String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(GENERATR_ALG);
        sb.append("RSA");
        sb.append(NEW_LINE_STR);
        sb.append("key size: ");
        sb.append(2048);
        return sb.toString();
    }

    public static enum KeyType {
        PUBLIC_KEY("public key"),
        PRIVATE_KEY("private key");

        String type;

        private KeyType(String type) {
            this.type = type;
        }
    }
}

