/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.keygen;

import com.bocom.api.security.crypt.impl.AESCryptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;

public class SM2KeyGen {
    private static final String PUBLIC_KEY = "sm2key.pub";
    private static final String PRIVATE_KEY = "sm2key.pri";
    private static final String WARNNING = "failed to generate key.";

    public static void main(String[] args) throws Exception {
        try {
            FileOutputStream priOs = new FileOutputStream(PRIVATE_KEY);
            FileOutputStream pubOs = new FileOutputStream(PUBLIC_KEY);
            SM2KeyGen.genSm2WithoutNewline(priOs, pubOs);
        }
        catch (Exception e) {
            throw new Exception(WARNNING, e);
        }
    }

    public static void genSm2WithoutNewline(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream) throws Exception {
        KeyPair kp = SM2KeyGen.generateKeyPair();
        SM2KeyGen.savePrivateKeyWithoutNewline(priKeyOutputStream, SM2KeyGen.getPrivateKey(kp), null);
        SM2KeyGen.savePublicKeyWithoutNewline(pubKeyOutputStream, SM2KeyGen.getPublicKey(kp));
    }

    protected static void savePrivateKeyWithoutNewline(OutputStream priKeyOutputStream, byte[] priKeyBytes, String password) throws Exception {
        try {
            if (password != null) {
                priKeyBytes = new AESCryptor().encrypt(priKeyBytes, password, "UTF-8");
            }
            priKeyOutputStream.write(priKeyBytes);
        }
        finally {
            priKeyOutputStream.flush();
            priKeyOutputStream.close();
        }
    }

    protected static void savePublicKeyWithoutNewline(OutputStream pubKeyOutputStream, byte[] pubKeyBytes) throws Exception {
        try {
            pubKeyOutputStream.write(pubKeyBytes);
        }
        finally {
            pubKeyOutputStream.flush();
            pubKeyOutputStream.close();
        }
    }

    public static KeyPair generateKeyPair() throws Exception {
        return SM2KeyGen.genKey();
    }

    private static KeyPair genKey() throws Exception {
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
        kpg.initialize(sm2Spec);
        kpg.initialize(sm2Spec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static String getPubKey(KeyPair keyPair) {
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        String pubKeyString = ByteUtils.toHexString((byte[])publicKey.getQ().getEncoded(false)).toUpperCase();
        return pubKeyString;
    }

    public static String getPriKey(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        String priKeyString = ByteUtils.toHexString((byte[])privateKey.getD().toByteArray()).toUpperCase();
        return priKeyString;
    }

    public static byte[] getPublicKey(KeyPair keyPair) {
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        return Hex.encode((byte[])publicKey.getQ().getEncoded(false));
    }

    public static byte[] getPrivateKey(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        return Hex.encode((byte[])privateKey.getD().toByteArray());
    }

    public static PublicKey getPublicKey(byte[] publicKey) throws Exception {
        X9ECParameters parameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECParameterSpec ecParameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH());
        ECPoint ecPoint = parameters.getCurve().decodePoint(Hex.decode((byte[])publicKey));
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        return keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
    }

    public static PrivateKey getPrivateKey(byte[] privateKey) throws Exception {
        X9ECParameters parameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECParameterSpec ecParameterSpec = new ECParameterSpec(parameters.getCurve(), parameters.getG(), parameters.getN(), parameters.getH());
        BigInteger bigInteger = new BigInteger(Hex.decode((byte[])privateKey));
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        return keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
    }
}

