/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.BocomApiException;
import com.bocom.api.security.spi.CryptorSpi;
import com.bocom.api.security.spi.impl.OpenBankAsyDecryptSpi;
import com.bocom.api.utils.BocomEncrypt;
import com.bocom.api.utils.BocomSignature;
import com.bocom.api.utils.enums.EncryptType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;

public class ApiUtils {
    private static ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static Object parseNotifyJsonWithBocomSign(String notifyStr, String charset, String APIGW_PUBLIC_KEY, Class T) throws BocomApiException {
        String bizContentStr = null;
        String sign = null;
        try {
            int indexOfRootStart = notifyStr.indexOf("notify_biz_content") + "notify_biz_content".length() + 2;
            int indexOfRootEnd = notifyStr.lastIndexOf(",");
            int indexOfSignStart = notifyStr.lastIndexOf("sign\"") + "sign".length() + 3;
            int indexOfSignEnd = notifyStr.lastIndexOf("\"");
            bizContentStr = notifyStr.substring(indexOfRootStart, indexOfRootEnd);
            sign = notifyStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            throw new BocomApiException("notify_biz_content is not format json. notifyStr :\n" + notifyStr, e);
        }
        boolean passed = BocomSignature.verify(EncryptType.RSA_AND_AES, bizContentStr, APIGW_PUBLIC_KEY, charset, sign);
        if (!passed) {
            throw new BocomApiException("Bocom sign verify not passed.");
        }
        try {
            return objectMapper.readValue(bizContentStr, T);
        }
        catch (Exception e) {
            throw new BocomApiException("notify_biz_content can not transform to defined class. response: " + notifyStr + " defined class name: " + T.getName(), e);
        }
    }

    public static Object parseNotifyJsonWithBocomSign(EncryptType encryptType, String notifyStr, String charset, String APIGW_PUBLIC_KEY, Class T) throws BocomApiException {
        String bizContentStr = null;
        String sign = null;
        try {
            int indexOfRootStart = notifyStr.indexOf("notify_biz_content") + "notify_biz_content".length() + 2;
            int indexOfRootEnd = notifyStr.lastIndexOf(",");
            int indexOfSignStart = notifyStr.lastIndexOf("sign\"") + "sign".length() + 3;
            int indexOfSignEnd = notifyStr.lastIndexOf("\"");
            bizContentStr = notifyStr.substring(indexOfRootStart, indexOfRootEnd);
            sign = notifyStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            throw new BocomApiException("notify_biz_content is not format json. notifyStr :\n" + notifyStr, e);
        }
        boolean passed = BocomSignature.verify(encryptType, bizContentStr, APIGW_PUBLIC_KEY, charset, sign);
        if (!passed) {
            throw new BocomApiException("Bocom sign verify not passed.");
        }
        try {
            return objectMapper.readValue(bizContentStr, T);
        }
        catch (Exception e) {
            throw new BocomApiException("notify_biz_content can not transform to defined class. response: " + notifyStr + " defined class name: " + T.getName(), e);
        }
    }

    public static HashMap<String, String> parseCommunicationJsonWithBocomSign(String respStr, String privateKey, String publicKey) throws BocomApiException {
        OpenBankAsyDecryptSpi cryptorSpi = new OpenBankAsyDecryptSpi(privateKey);
        return ApiUtils.parseCommunicationJsonWithBocomSign(EncryptType.RSA_AND_AES, respStr, cryptorSpi, publicKey);
    }

    public static HashMap<String, String> parseCommunicationJsonWithBocomSign(EncryptType encryptType, String respStr, CryptorSpi cryptorSpi, String bocomPublicKey) throws BocomApiException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String respBizContentStr = null;
        String sign = null;
        try {
            int indexOfRootEnd = respStr.lastIndexOf(",");
            int indexOfSignStart = respStr.lastIndexOf("sign\"") + "sign".length() + 3;
            int indexOfSignEnd = respStr.lastIndexOf("\"");
            respBizContentStr = respStr.substring(1, indexOfRootEnd);
            sign = respStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            throw new BocomApiException("response is not format json. respStr :\n" + respStr, e);
        }
        boolean passed = BocomSignature.verify(encryptType, respBizContentStr, bocomPublicKey, "utf-8", sign);
        if (!passed) {
            throw new BocomApiException("Bocom sign verify not passed.");
        }
        try {
            HashMap jsonObj = (HashMap)objectMapper.readValue(respStr, HashMap.class);
            String encryptKeyEncrypt = (String)jsonObj.get("encrypt_key");
            String reqBizContentEncrypt = (String)jsonObj.get("biz_content");
            String encryptKey = cryptorSpi.decrypt(encryptKeyEncrypt);
            String reqBizContent = BocomEncrypt.symDecryptContent(reqBizContentEncrypt, encryptType, encryptKey, "UTF-8");
            resultMap.put("biz_content", reqBizContent);
            resultMap.put("encrypt_key", encryptKey);
            resultMap.put("msg_id", (String)jsonObj.get("msg_id"));
            resultMap.put("timestamp", (String)jsonObj.get("timestamp"));
        }
        catch (Exception e) {
            throw new BocomApiException("Bocom decrypt not success.", e);
        }
        return resultMap;
    }

    public static HashMap<String, String> parseCommunicationJsonWithBocomSign(EncryptType encryptType, String respStr, String privateKey, String publicKey) throws BocomApiException {
        OpenBankAsyDecryptSpi cryptorSpi = new OpenBankAsyDecryptSpi(privateKey);
        return ApiUtils.parseCommunicationJsonWithBocomSign(encryptType, respStr, cryptorSpi, publicKey);
    }

    public static String signRspBizContent(String rspBizContent, String encryptKey, String privateKey) throws BocomApiException {
        String signContent;
        String rspContent = BocomEncrypt.symEncryptContent(rspBizContent, EncryptType.RSA_AND_AES, encryptKey, "UTF-8");
        try {
            signContent = BocomSignature.sign(EncryptType.RSA_AND_AES, rspContent, privateKey, "UTF-8", "");
        }
        catch (Exception e) {
            throw new BocomApiException("Bocom sign not success.");
        }
        String newBody = "{\"rsp_biz_content\":\"" + rspContent + "\",\"sign\":\"" + signContent + "\"}";
        return newBody;
    }

    public static String signRspBizContent(EncryptType encryptType, String rspBizContent, String encryptKey, String privateKey) throws BocomApiException {
        String signContent;
        String rspContent = BocomEncrypt.symEncryptContent(rspBizContent, encryptType, encryptKey, "UTF-8");
        try {
            signContent = BocomSignature.sign(encryptType, rspContent, privateKey, "UTF-8", "");
        }
        catch (Exception e) {
            throw new BocomApiException("Bocom sign not success.");
        }
        String newBody = "{\"rsp_biz_content\":\"" + rspContent + "\",\"sign\":\"" + signContent + "\"}";
        return newBody;
    }
}

