/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.BocomApiException;
import com.bocom.api.security.keygen.SM2KeyGen;
import com.bocom.api.security.sign.ApiSignature;
import com.bocom.api.security.sign.impl.RSASignature;
import com.bocom.api.security.sign.impl.SM2Signature;
import com.bocom.api.utils.Base64;
import com.bocom.api.utils.enums.EncryptType;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;

public class BocomSignature {
    private static ApiSignature apiSignature = new RSASignature();
    private static SM2Signature SM2Signature = new SM2Signature();

    public static String sign(EncryptType type, String content, String privateKey, String charset) throws BocomApiException {
        return BocomSignature.sign(type, content, privateKey, charset, null);
    }

    public static void main(String[] args) throws Exception {
        String text = "{\"return}";
        KeyPair keyPair = SM2KeyGen.generateKeyPair();
        String publicKey = SM2KeyGen.getPubKey(keyPair);
        String privateKey = SM2KeyGen.getPriKey(keyPair);
        String priKey = "1036CDE9444AA0F4885CF6BDC28C96F4D3EDED2214F25A28683B030B5B07707E";
        String sign = BocomSignature.sign(EncryptType.SM2_AND_SM4, text, privateKey, "UTF-8", "");
        String pubKey = "04E0C3E0A4B059715C784A28AE061B5E9D50682D99F0CD0D9C6FA38036327FB69271B934189AF39FBA423933D34EAD65361B005037D4018FA9012112B914674C";
        System.out.println(BocomSignature.verify(EncryptType.SM2_AND_SM4, text, publicKey, "UTF-8", sign));
    }

    public static String sign(EncryptType type, String content, String privateKey, String charset, String password) throws BocomApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (EncryptType.RSA_AND_AES == type) {
                return apiSignature.sign(contentBytes, Base64.decode(privateKey), "SHA256WithRSA");
            }
            if (EncryptType.SM2_AND_SM4 == type) {
                return SM2Signature.sign(contentBytes, privateKey.getBytes(charset), GMObjectIdentifiers.sm2sign_with_sm3.getId());
            }
            throw new BocomApiException("\u975e\u5bf9\u79f0\u52a0\u5bc6\u7b97\u6cd5\u7b7e\u540d\u53ea\u63d0\u4f9bRSA\u548cSM2");
        }
        catch (UnsupportedEncodingException e) {
            throw new BocomApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            throw new BocomApiException("sign exception.", e);
        }
    }

    public static boolean verify(EncryptType type, String content, String publicKey, String charset, String sign) throws BocomApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (EncryptType.RSA_AND_AES == type) {
                return apiSignature.verify(contentBytes, Base64.decode(publicKey), sign, "SHA256WithRSA");
            }
            if (EncryptType.SM2_AND_SM4 == type) {
                return SM2Signature.verify(contentBytes, publicKey.getBytes(charset), sign, GMObjectIdentifiers.sm2sign_with_sm3.getId());
            }
            throw new BocomApiException("\u975e\u5bf9\u79f0\u52a0\u5bc6\u7b97\u6cd5\u9a8c\u7b7e\u53ea\u63d0\u4f9bRSA\u548cSM2");
        }
        catch (UnsupportedEncodingException e) {
            throw new BocomApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            throw new BocomApiException("sign verify exception.", e);
        }
    }

    public static String sign(byte[] contentBytes, String privateKey, String charset, String password) throws BocomApiException {
        try {
            if (password != null) {
                // empty if block
            }
            return apiSignature.sign(contentBytes, Base64.decode(privateKey), "SHA256WithRSA");
        }
        catch (Exception e) {
            throw new BocomApiException("sign exception.", e);
        }
    }

    public static boolean verify(byte[] contentBytes, String publicKey, String charset, String sign) throws BocomApiException {
        try {
            return apiSignature.verify(contentBytes, Base64.decode(publicKey), sign, "SHA256WithRSA");
        }
        catch (Exception e) {
            throw new BocomApiException("sign verify exception.", e);
        }
    }
}

