/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.utils.FileItem;
import com.bocom.api.utils.NewDefaultTlsClient;
import com.bocom.api.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientProtocol;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.http.Handler;

public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String FILE_DOWNLOAD_CONTENT_TYPE_KEY = "application/octet-stream";
    private static final String USER_AGENT_KEY = "bankcomm-sdk-java_v2.0";
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;
    private static final Logger logger = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static void ignoreSSLHostnameVerifier() {
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPost(url, ctype, content, connectTimeout, readTimeout, proxyHost, proxyPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = null;
            conn = !StringUtils.isEmpty(proxyHost) ? WebUtils.getConnection(new URL(url), METHOD_POST, ctype, proxyHost, proxyPort) : WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, String downloadPath, String returnHeaderField, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = !StringUtils.isEmpty(proxyHost) ? WebUtils.getConnection(new URL(url), METHOD_POST, ctype, proxyHost, proxyPort) : WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
        }
        catch (IOException e) {
            throw new IOException("api connect host err");
        }
        try {
            out = conn.getOutputStream();
            out.write(content);
            String contentType = conn.getContentType();
            rsp = contentType != null && contentType.toLowerCase().startsWith(FILE_DOWNLOAD_CONTENT_TYPE_KEY) ? WebUtils.getResponseAsDownloadStream(conn, downloadPath, returnHeaderField) : WebUtils.getResponseAsString(conn);
        }
        catch (IOException e) {
            throw new IOException("\u6587\u4ef6\u6d41\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, String downloadPath, String returnHeaderField, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String encrptKey, String securityType) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = !StringUtils.isEmpty(proxyHost) ? WebUtils.getConnection(new URL(url), METHOD_POST, ctype, proxyHost, proxyPort) : WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        try {
            out = conn.getOutputStream();
            out.write(content);
            String contentType = conn.getContentType();
            rsp = contentType != null && contentType.toLowerCase().startsWith(FILE_DOWNLOAD_CONTENT_TYPE_KEY) ? WebUtils.getResponseAsDownloadStream(conn, downloadPath, returnHeaderField) : WebUtils.getResponseAsString(conn);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        return WebUtils.getConnection(url, method, ctype, null);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, String proxyHost, int proxyPort) throws IOException {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        return WebUtils.getConnection(url, method, ctype, proxy);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            url = new URL(null, url.toString(), new sun.net.www.protocol.https.Handler());
            HttpsURLConnection connHttps = null;
            connHttps = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            url = new URL(null, url.toString(), new Handler());
            conn = null;
            conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("User-Agent", USER_AGENT_KEY);
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        logger.info("query params: " + URLDecoder.decode(query.toString(), charset));
        return query.toString();
    }

    public static String buildOrderedSignStr(String path, Map<String, String> params) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(params);
        Set entries = sortedMap.entrySet();
        boolean hasParam = false;
        StringBuilder sb = new StringBuilder(path);
        sb.append("?");
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.areNotEmpty(name, value)) continue;
            if (hasParam) {
                sb.append("&");
            } else {
                hasParam = true;
            }
            sb.append(name).append("=").append(value);
        }
        return sb.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponseAsDownloadStream(HttpURLConnection conn, String downloadPath, String returnHeaderField) throws IOException {
        FileOutputStream fos = null;
        InputStream in = null;
        String rspStr = null;
        try {
            File filePath;
            String disposition = conn.getHeaderField("Content-Disposition");
            String charSet = WebUtils.getResponseCharset(conn.getContentType());
            String fileName = URLDecoder.decode(disposition.substring(disposition.indexOf("filename=") + 9), charSet) + ".TMP";
            rspStr = URLDecoder.decode(conn.getHeaderField(returnHeaderField), charSet);
            byte[] buffer = new byte[8192];
            int read = 0;
            in = conn.getInputStream();
            if (!downloadPath.endsWith("/") && !downloadPath.endsWith("\\")) {
                downloadPath = downloadPath + "/";
            }
            if (!(filePath = new File(downloadPath)).exists()) {
                filePath.mkdirs();
            }
            fos = new FileOutputStream(downloadPath + fileName);
            while ((read = in.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
                fos.flush();
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return rspStr;
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, params, charset, connectTimeout, readTimeout, proxyHost, proxyPort);
        }
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;boundary=" + boundary + ";charset=" + charset;
            conn = null;
            conn = !StringUtils.isEmpty(proxyHost) ? WebUtils.getConnection(new URL(url), METHOD_POST, ctype, proxyHost, proxyPort) : WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
            Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
            logger.info("text params: " + textEntrySet.toString());
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] byArray = WebUtils.getTextEntry(entry.getKey(), entry.getValue(), charset);
                out.write(entryBoundaryBytes);
                out.write(byArray);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                byte[] fileBytes = WebUtils.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
            out.write(byArray);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(URLEncoder.encode(fileName, charset));
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    static {
        try {
            String jdkVersion = System.getProperty("java.version");
            if (jdkVersion.length() >= 3 && jdkVersion.startsWith("1.6")) {
                socketFactory = new SSLSocketFactory(){
                    {
                        if (Security.getProvider("BC") == null) {
                            Security.addProvider((Provider)new BouncyCastleProvider());
                        }
                    }

                    @Override
                    public Socket createSocket(Socket socket, String host, int port, boolean arg3) throws IOException {
                        if (socket == null) {
                            socket = new Socket();
                        }
                        if (!socket.isConnected()) {
                            socket.connect(new InetSocketAddress(host, port));
                        }
                        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(socket.getInputStream(), socket.getOutputStream(), new SecureRandom());
                        return this.createSSLSocket_(host, tlsClientProtocol);
                    }

                    @Override
                    public String[] getDefaultCipherSuites() {
                        return null;
                    }

                    @Override
                    public String[] getSupportedCipherSuites() {
                        return null;
                    }

                    @Override
                    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Socket createSocket(InetAddress host, int port) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                        return null;
                    }

                    @Override
                    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    private SSLSocket createSSLSocket_(final String host, final TlsClientProtocol tlsClientProtocol) {
                        return new SSLSocket(){
                            private java.security.cert.Certificate[] peertCerts;

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return tlsClientProtocol.getInputStream();
                            }

                            @Override
                            public OutputStream getOutputStream() throws IOException {
                                return tlsClientProtocol.getOutputStream();
                            }

                            @Override
                            public synchronized void close() throws IOException {
                                tlsClientProtocol.close();
                            }

                            @Override
                            public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
                            }

                            @Override
                            public boolean getEnableSessionCreation() {
                                return false;
                            }

                            @Override
                            public String[] getEnabledCipherSuites() {
                                return null;
                            }

                            @Override
                            public String[] getEnabledProtocols() {
                                return null;
                            }

                            @Override
                            public boolean getNeedClientAuth() {
                                return false;
                            }

                            @Override
                            public SSLSession getSession() {
                                return new SSLSession(){

                                    @Override
                                    public int getApplicationBufferSize() {
                                        return 0;
                                    }

                                    @Override
                                    public String getCipherSuite() {
                                        return null;
                                    }

                                    @Override
                                    public long getCreationTime() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public byte[] getId() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public long getLastAccessedTime() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public java.security.cert.Certificate[] getLocalCertificates() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public Principal getLocalPrincipal() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public int getPacketBufferSize() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                                        return null;
                                    }

                                    @Override
                                    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                                        return peertCerts;
                                    }

                                    @Override
                                    public String getPeerHost() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public int getPeerPort() {
                                        return 0;
                                    }

                                    @Override
                                    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                                        return null;
                                    }

                                    @Override
                                    public String getProtocol() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public SSLSessionContext getSessionContext() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public Object getValue(String arg0) {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public String[] getValueNames() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public void invalidate() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public boolean isValid() {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public void putValue(String arg0, Object arg1) {
                                        throw new UnsupportedOperationException();
                                    }

                                    @Override
                                    public void removeValue(String arg0) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public String[] getSupportedProtocols() {
                                return null;
                            }

                            @Override
                            public boolean getUseClientMode() {
                                return false;
                            }

                            @Override
                            public boolean getWantClientAuth() {
                                return false;
                            }

                            @Override
                            public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
                            }

                            @Override
                            public void setEnableSessionCreation(boolean arg0) {
                            }

                            @Override
                            public void setEnabledCipherSuites(String[] arg0) {
                            }

                            @Override
                            public void setEnabledProtocols(String[] arg0) {
                            }

                            @Override
                            public void setNeedClientAuth(boolean arg0) {
                            }

                            @Override
                            public void setUseClientMode(boolean arg0) {
                            }

                            @Override
                            public void setWantClientAuth(boolean arg0) {
                            }

                            @Override
                            public String[] getSupportedCipherSuites() {
                                return null;
                            }

                            @Override
                            public void startHandshake() throws IOException {
                                tlsClientProtocol.connect((TlsClient)new NewDefaultTlsClient(){

                                    public Hashtable<Integer, byte[]> getClientExtensions() throws IOException {
                                        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
                                        if (clientExtensions == null) {
                                            clientExtensions = new Hashtable<Integer, byte[]>();
                                        }
                                        byte[] hostName = host.getBytes();
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        DataOutputStream dos = new DataOutputStream(baos);
                                        dos.writeShort(hostName.length + 3);
                                        dos.writeByte(0);
                                        dos.writeShort(hostName.length);
                                        dos.write(hostName);
                                        dos.close();
                                        clientExtensions.put(0, baos.toByteArray());
                                        return clientExtensions;
                                    }

                                    @Override
                                    public TlsAuthentication getAuthentication() throws IOException {
                                        return new TlsAuthentication(){

                                            public void notifyServerCertificate(org.bouncycastle.crypto.tls.Certificate serverCertificate) throws IOException {
                                                try {
                                                    KeyStore ks = this.loadKeyStore_();
                                                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                                    LinkedList<java.security.cert.Certificate> certs = new LinkedList<java.security.cert.Certificate>();
                                                    boolean trustedCertificate = false;
                                                    for (Certificate c : serverCertificate.getCertificateList()) {
                                                        java.security.cert.Certificate cert = cf.generateCertificate(new ByteArrayInputStream(c.getEncoded()));
                                                        certs.add(cert);
                                                        String alias = ks.getCertificateAlias(cert);
                                                        if (alias == null || !(cert instanceof java.security.cert.X509Certificate)) continue;
                                                        try {
                                                            ((java.security.cert.X509Certificate)cert).checkValidity();
                                                            trustedCertificate = true;
                                                        }
                                                        catch (CertificateExpiredException certificateExpiredException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (!trustedCertificate) {
                                                        // empty if block
                                                    }
                                                    1.access$002(this, certs.toArray(new java.security.cert.Certificate[0]));
                                                }
                                                catch (Exception ex) {
                                                    ex.printStackTrace();
                                                    throw new IOException(ex);
                                                }
                                            }

                                            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                                                return null;
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            private KeyStore loadKeyStore_() throws Exception {
                                                try (FileInputStream trustStoreFis = null;){
                                                    String trustStoreProvider;
                                                    KeyStore localKeyStore = null;
                                                    String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType") != null ? System.getProperty("javax.net.ssl.trustStoreType") : KeyStore.getDefaultType();
                                                    String string = trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider") != null ? System.getProperty("javax.net.ssl.trustStoreProvider") : "";
                                                    if (trustStoreType.length() != 0) {
                                                        String str5;
                                                        localKeyStore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
                                                        char[] keyStorePass = null;
                                                        String string2 = str5 = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword") : "";
                                                        if (str5.length() != 0) {
                                                            keyStorePass = str5.toCharArray();
                                                        }
                                                        localKeyStore.load(trustStoreFis, keyStorePass);
                                                        if (keyStorePass != null) {
                                                            for (int i = 0; i < keyStorePass.length; ++i) {
                                                                keyStorePass[i] = '\u0000';
                                                            }
                                                        }
                                                    }
                                                    KeyStore keyStore = localKeyStore;
                                                    return keyStore;
                                                }
                                            }
                                        };
                                    }
                                });
                            }

                            static /* synthetic */ java.security.cert.Certificate[] access$002(1 x0, java.security.cert.Certificate[] x1) {
                                x0.peertCerts = x1;
                                return x1;
                            }
                        };
                    }
                };
            } else {
                ctx = SSLContext.getInstance("TLSV1.2");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                ctx.getClientSessionContext().setSessionTimeout(15);
                ctx.getClientSessionContext().setSessionCacheSize(1000);
                socketFactory = ctx.getSocketFactory();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Initializing WebUtils Error!", e);
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return false;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

