/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.enums;

import com.xwbank.sdk.strategy.RequestStrategy;
import com.xwbank.sdk.strategy.impl.request.PostRequestStrategy;
import javax.validation.constraints.NotNull;

public enum RequestStrategyEnum {
    REQUEST_STRATEGY_POST("POST", new PostRequestStrategy());

    private final String requestType;
    private final RequestStrategy requestStrategy;

    private RequestStrategyEnum(String requestType, RequestStrategy requestStrategy) {
        this.requestType = requestType;
        this.requestStrategy = requestStrategy;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public RequestStrategy getRequestStrategy() {
        return this.requestStrategy;
    }

    public static RequestStrategy getRequestStrategy(@NotNull String requestType) {
        RequestStrategyEnum[] enums;
        for (RequestStrategyEnum strategyEnum : enums = RequestStrategyEnum.values()) {
            if (!strategyEnum.getRequestType().equalsIgnoreCase(requestType)) continue;
            return strategyEnum.getRequestStrategy();
        }
        return null;
    }
}

