/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.manager;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.http.entity.InitParam;
import com.xwbank.sdk.strategy.impl.config.BaseApplicationConfigStrategy;
import com.xwbank.sdk.utils.JacksonUtil;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.apache.http.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    private static ConfigManager configManager;
    private final Map<String, ApplicationConfig> configMap = new ConcurrentHashMap<String, ApplicationConfig>();

    public Map<String, ApplicationConfig> getConfigMap() {
        return this.configMap;
    }

    public ApplicationConfig getConfig(@NotNull String appId) {
        return this.configMap.get(appId);
    }

    private ConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getInstance() {
        if (configManager != null) return configManager;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (configManager != null) return configManager;
            configManager = new ConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configManager;
        }
    }

    public void init(InitParam param) throws SDKException {
        logger.info("\u521d\u59cb\u5316\u4fe1\u606f: {}", (Object)JacksonUtil.toJSONString(param));
        try {
            Asserts.notEmpty((CharSequence)param.getConfigPath(), (String)"\u914d\u7f6e\u6587\u4ef6\u8def\u5f84");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        ApplicationConfig config = new BaseApplicationConfigStrategy().doInvoke(param.getConfigPath());
        try {
            Asserts.notEmpty((CharSequence)config.getAppId(), (String)"appId");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        config.setKeyStorePath(param.getKeyPath());
        try {
            SM2PrivateKey priKey = KeyUtil.getPrivateKeyFromSM2((String)param.getKeyPath(), (String)config.getKeyPwd());
            config.setPrivateKey((PrivateKey)priKey);
            X509Cert cert = new X509Cert(config.getPublicKeyStr().getBytes());
            config.setPublicKey(cert.getPublicKey());
        }
        catch (PKIException e) {
            throw new SDKException(e);
        }
        config.setTrustFilePath(param.getCerPath());
        logger.info("\u8bfb\u53d6\u5f53\u524d\u7684\u914d\u7f6e\u4fe1\u606f: {}", (Object)JacksonUtil.toJSONString(config));
        this.configMap.put(config.getAppId(), config);
    }

    public void init(List<InitParam> params) throws SDKException {
        try {
            Asserts.notNull(params, (String)"\u914d\u7f6e\u5bf9\u8c61");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        for (InitParam param : params) {
            this.init(param);
        }
    }

    public void initStream(InitParam param) throws SDKException {
        try {
            Asserts.notNull((Object)param.getConfigStream(), (String)"\u914d\u7f6e\u6587\u4ef6\u6d41");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        ApplicationConfig config = new BaseApplicationConfigStrategy().doInvoke(param.getConfigStream());
        try {
            Asserts.notEmpty((CharSequence)config.getAppId(), (String)"appId");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        config.setKeyStoreStream(param.getKeyStream());
        try {
            SM2PrivateKey priKey = KeyUtil.getPrivateKeyFromSM2((InputStream)param.getKeyStream(), (String)config.getKeyPwd());
            config.setPrivateKey((PrivateKey)priKey);
            X509Cert cert = new X509Cert(config.getPublicKeyStr().getBytes());
            config.setPublicKey(cert.getPublicKey());
        }
        catch (PKIException e) {
            throw new SDKException(e);
        }
        config.setTrustFileStream(param.getCerStream());
        logger.info("\u8bfb\u53d6\u5f53\u524d\u7684\u914d\u7f6e\u4fe1\u606f: {}", (Object)JacksonUtil.toJSONString(config));
        this.configMap.put(config.getAppId(), config);
    }

    public void initStream(List<InitParam> params) throws SDKException {
        try {
            Asserts.notNull(params, (String)"\u914d\u7f6e\u6d41\u96c6\u5408");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        for (InitParam param : params) {
            this.initStream(param);
        }
    }

    public void init(ApplicationConfig config) throws SDKException {
        try {
            Asserts.notEmpty((CharSequence)config.getAppId(), (String)"appId");
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        logger.info("\u624b\u52a8\u8bbe\u7f6e\u7684\u53c2\u6570: {}", (Object)JacksonUtil.toJSONString(config));
        this.configMap.put(config.getAppId(), config);
    }
}

