/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.utils.DateUtils;
import com.xwbank.sdk.utils.JacksonUtil;
import com.xwbank.sdk.utils.sm.SM2Util;
import com.xwbank.sdk.utils.sm.SM4Util;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GmUtil {
    public static Map<String, Object> encryptAndSign(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        sendMap.put("reqTime", DateUtils.formateCurrentDate());
        try {
            String pwd = SM4Util.getRandomStr(32);
            sendMap.put("ScrtKey", SM2Util.encrypt(publicKey, pwd));
            String sourceData = JacksonUtil.toJSONString(params);
            sendMap.put("data", SM4Util.encrypt(pwd.getBytes(StandardCharsets.UTF_8), sourceData));
            sourceData = GmUtil.sortString(sendMap);
            sendMap.put("sign", SM2Util.sign(privateKey, sourceData));
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", e);
        }
        return sendMap;
    }

    public static Map<String, Object> verifySignAndDecrypt(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String sign = (String)params.remove("sign");
            String sortStr = GmUtil.sortString(params);
            if (!SM2Util.verifySign(publicKey, sortStr, sign)) {
                resultMap.put("returnCode", "110110");
                resultMap.put("returnMsg", "\u8fd4\u56de\u6570\u636e\uff0csdk\u9a8c\u7b7e\u5931\u8d25");
                return resultMap;
            }
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u9a8c\u7b7e\u5f02\u5e38", e);
        }
        try {
            String scrtKey = params.remove("ScrtKey").toString();
            byte[] bytesTxt = SM2Util.decrypt(privateKey, scrtKey.getBytes(StandardCharsets.UTF_8));
            String data = SM4Util.decrypt(bytesTxt, params.get("data").toString());
            params.put("data", data);
            return params;
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static Map<String, Object> noticeEncryptAndSign(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        sendMap.put("respTime", DateUtils.formateCurrentDate());
        try {
            String pwd = SM4Util.getRandomStr(32);
            sendMap.put("ScrtKey", SM2Util.encrypt(publicKey, pwd));
            String sourceData = JacksonUtil.toJSONString(params);
            sendMap.put("data", SM4Util.encrypt(pwd.getBytes(StandardCharsets.UTF_8), sourceData));
            sourceData = GmUtil.sortString(sendMap);
            sendMap.put("sign", SM2Util.sign(privateKey, sourceData));
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", e);
        }
        return sendMap;
    }

    public static String sortString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder linkStr = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = (String)params.get(key);
            if (value == null) continue;
            if (i == keys.size() - 1) {
                linkStr.append(key).append("=").append(value);
                continue;
            }
            linkStr.append(key).append("=").append(value).append("&");
        }
        return linkStr.toString();
    }
}

