/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.verify;

import com.xwbank.sdk.verify.Check;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckValue {
    public static Logger log = LoggerFactory.getLogger(CheckValue.class);
    public Map<String, String> map = new HashMap<String, String>();
    public Map<String, Object> errMap = new HashMap<String, Object>();

    public CheckValue() {
        this.map.put("*", "[\\w\\W]+");
        this.map.put("email", "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
        this.map.put("price", "^[0-9]{1,6}(\\.[0-9]{1,2})?$");
        this.map.put("postCode", "[0-9]{6}$");
        this.map.put("d", "[0-9]{1,}");
        this.map.put("phone", "[0-9]{1,}");
        this.map.put("url", "(\\w+:\\/\\/)?\\w+(\\.\\w+)+.*$");
        this.map.put("idNo", "(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])|");
        this.map.put("json", "{\\.*\\}");
        this.map.put("name", "^[\\u4e00-\\u9fa5]+[\u00b7?][\\u4e00-\\u9fa5]+$||^[\\u4e00-\\u9fa5]+$||[A-Za-z]{0,20}");
        this.map.put("zh", "[\u4e00-\u9fa5]+");
        this.map.put("date", "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s((([0-1][0-9])|(2?[0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        this.map.put("date_yyyy_MM_dd_HH_mm_ss", "^(((20[0-3][0-9]-(0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|(20[0-3][0-9]-(0[2469]|11)-(0[1-9]|[12][0-9]|30))) (20|21|22|23|[0-1][0-9]):[0-5][0-9]:[0-5][0-9])$");
        this.map.put("date_yyyy_MM_dd", "^[0-9]{4}-(((0[13578]|(10|12))-(0[1-9]|[1-2][0-9]|3[0-1]))|(02-(0[1-9]|[1-2][0-9]))|((0[469]|11)-(0[1-9]|[1-2][0-9]|30)))$");
    }

    public boolean check(Class<?> clazz, Object obj) {
        if (obj == null) {
            return true;
        }
        int error = 100010;
        boolean chenkRS = true;
        String missmsg = "sdk\u6570\u636e\u6821\u9a8c&";
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        Field[] fileds = clazz.getDeclaredFields();
        for (int i = 0; i < fileds.length; ++i) {
            Field field = fileds[i];
            Check check = field.getAnnotation(Check.class);
            if (check == null) continue;
            try {
                String fieldname = field.getName();
                StringBuffer methodName = new StringBuffer("get");
                methodName.append(fieldname.substring(0, 1).toUpperCase());
                methodName.append(fieldname.substring(1));
                Method method = clazz.getMethod(methodName.toString(), new Class[0]);
                Object str = method.invoke(obj, new Object[0]);
                if (CheckValue.isNotEmpty(str)) {
                    str = str.toString().trim();
                }
                if (check.notNull() && !CheckValue.isNotEmpty(str)) {
                    errMap.put(missmsg + error, check.errorMsg());
                    ++error;
                }
                if (check.maxLength() > 0 && check.mineLiegth() == -1) {
                    if (CheckValue.isNotEmpty(str) && str.toString().length() > check.maxLength()) {
                        errMap.put(missmsg + error, check.errorMsg());
                        ++error;
                    }
                } else if (check.maxLength() > 0 && check.mineLiegth() > -1) {
                    if (CheckValue.isNotEmpty(str)) {
                        if (str.toString().length() > check.maxLength() || str.toString().length() < check.mineLiegth()) {
                            errMap.put(missmsg + error, check.errorMsg());
                            ++error;
                        }
                    } else {
                        errMap.put(missmsg + error, check.errorMsg());
                        ++error;
                    }
                } else if (check.maxLength() == -1 && check.mineLiegth() > -1) {
                    if (CheckValue.isNotEmpty(str)) {
                        if (str.toString().length() < check.mineLiegth()) {
                            errMap.put(missmsg + error, check.errorMsg());
                            ++error;
                        }
                    } else {
                        errMap.put(missmsg + error, check.errorMsg());
                        ++error;
                    }
                }
                if (!CheckValue.isNotEmpty(check.type())) continue;
                String reg = this.createRegex(check.type());
                if (!CheckValue.isNotEmpty(reg)) {
                    reg = check.type();
                }
                boolean rs = true;
                if (!CheckValue.isNotEmpty(check.type())) continue;
                if (CheckValue.isNotEmpty(str)) {
                    rs = this.isMatch(reg, str.toString());
                }
                if (check.ignore()) {
                    if (rs) continue;
                    errMap.put(missmsg + error, check.errorMsg());
                    ++error;
                    continue;
                }
                if (rs && CheckValue.isNotEmpty(str)) continue;
                errMap.put(missmsg + error, check.errorMsg());
                ++error;
                continue;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        if (!errMap.isEmpty()) {
            chenkRS = false;
            this.setErrMap(errMap);
        }
        return chenkRS;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, Object> getErrMap() {
        return this.errMap;
    }

    public void setErrMap(Map<String, Object> errMap) {
        this.errMap = errMap;
    }

    public static boolean isNotEmpty(Object str) {
        boolean flag = true;
        if (str == null || str.equals("") || str.equals("null")) {
            flag = false;
        } else {
            List s;
            if (str instanceof List && (s = (List)str).size() == 0) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public boolean isMatch(String regex, String str) {
        boolean b = true;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public String createRegex(String dataType) {
        Map<String, String> map = this.getMap();
        String rs = map.get(dataType);
        Pattern p = Pattern.compile("(zh(.*?)|y(.*?)|n(.*?)|s(.*?)|\\*(.*?))");
        Matcher m = p.matcher(dataType);
        while (m.find()) {
            String reg = map.get(m.group(0));
            if (!CheckValue.isNotEmpty(reg)) continue;
            String newReg = m.group(0);
            if (newReg.indexOf("*") > -1) {
                newReg = "\\" + newReg;
            }
            Pattern p1 = Pattern.compile(newReg + "(.*?);");
            Matcher m1 = p1.matcher(dataType + ";");
            while (m1.find()) {
                String type = m1.group(1);
                if (CheckValue.isNotEmpty(type) && type.indexOf("-") > -1) {
                    type = type.replaceAll("-", ",");
                    type = "{" + type + "}";
                    reg = reg.replaceAll("\\+", type);
                } else if (CheckValue.isNotEmpty(type) && type.indexOf("-") == -1) {
                    type = "{" + type + "}";
                    reg = reg.replaceAll("\\+", type);
                }
                rs = reg;
            }
        }
        return rs;
    }
}

