/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.ocsp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.ocsp.RevokedInfo;

public class CertStatus
extends ASN1Encodable {
    private int tagNo;
    private DEREncodable value;

    public CertStatus() {
        this.tagNo = 0;
        this.value = new DERNull();
    }

    public CertStatus(RevokedInfo revokedInfo) {
        this.tagNo = 1;
        this.value = revokedInfo;
    }

    public CertStatus(int n, DEREncodable dEREncodable) {
        this.tagNo = n;
        this.value = dEREncodable;
    }

    public CertStatus(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: {
                this.value = new DERNull();
                break;
            }
            case 1: {
                this.value = RevokedInfo.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 2: {
                this.value = new DERNull();
            }
        }
    }

    public static CertStatus getInstance(Object object) {
        if (object == null || object instanceof CertStatus) {
            return (CertStatus)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new CertStatus((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public DEREncodable getStatus() {
        return this.value;
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.tagNo, this.value);
    }
}

