/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class SignerInfo
extends ASN1Encodable {
    private DERInteger version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;

    public static SignerInfo getInstance(Object object) {
        if (object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SignerInfo(DERInteger dERInteger, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier algorithmIdentifier, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set2) {
        this.version = dERInteger;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = algorithmIdentifier;
        this.authenticatedAttributes = aSN1Set;
        this.digEncryptionAlgorithm = algorithmIdentifier2;
        this.encryptedDigest = aSN1OctetString;
        this.unauthenticatedAttributes = aSN1Set2;
    }

    public SignerInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(enumeration.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        Object e = enumeration.nextElement();
        if (e instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)e, false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e);
        }
        this.encryptedDigest = DEROctetString.getInstance(enumeration.nextElement());
        this.unauthenticatedAttributes = enumeration.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)enumeration.nextElement(), false) : null;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.issuerAndSerialNumber);
        aSN1EncodableVector.add(this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.authenticatedAttributes));
        }
        aSN1EncodableVector.add(this.digEncryptionAlgorithm);
        aSN1EncodableVector.add(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.unauthenticatedAttributes));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

