/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.x509.KeyUsage;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class BitStringTest
implements Test {
    public TestResult perform() {
        KeyUsage keyUsage = new KeyUsage(128);
        if (keyUsage.getBytes()[0] != -128 || keyUsage.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed digitalSignature");
        }
        keyUsage = new KeyUsage(64);
        if (keyUsage.getBytes()[0] != 64 || keyUsage.getPadBits() != 6) {
            return new SimpleTestResult(false, this.getName() + ": failed nonRepudiation");
        }
        keyUsage = new KeyUsage(32);
        if (keyUsage.getBytes()[0] != 32 || keyUsage.getPadBits() != 5) {
            return new SimpleTestResult(false, this.getName() + ": failed keyEncipherment");
        }
        keyUsage = new KeyUsage(2);
        if (keyUsage.getBytes()[0] != 2 || keyUsage.getPadBits() != 1) {
            return new SimpleTestResult(false, this.getName() + ": failed cRLSign");
        }
        keyUsage = new KeyUsage(32768);
        if (keyUsage.getBytes()[1] != -128 || keyUsage.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed decipherOnly");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "BitString";
    }

    public static void main(String[] stringArray) {
        BitStringTest bitStringTest = new BitStringTest();
        TestResult testResult = bitStringTest.perform();
        System.out.println(testResult);
    }
}

