/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OIDTest
implements Test {
    byte[] req = Hex.decode("0603813403");

    public String getName() {
        return "OID";
    }

    private TestResult valueCheck(String string) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObjectIdentifier);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        dERObjectIdentifier = (DERObjectIdentifier)aSN1InputStream.readObject();
        if (!dERObjectIdentifier.getId().equals(string)) {
            return new SimpleTestResult(false, this.getName() + ": failed oid check for " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.req);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("2.100.3");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dERObjectIdentifier);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != this.req.length) {
                return new SimpleTestResult(false, this.getName() + ": failed length test");
            }
            int n = 0;
            while (n != this.req.length) {
                if (byArray[n] != this.req[n]) {
                    return new SimpleTestResult(false, this.getName() + ": failed comparison test");
                }
                ++n;
            }
            TestResult testResult = this.valueCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.valueCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
            if (!testResult.isSuccessful()) {
                return testResult;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        OIDTest oIDTest = new OIDTest();
        TestResult testResult = oIDTest.perform();
        System.out.println(testResult);
    }
}

