/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.sec.ECPrivateKeyStructure;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ECPoint;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.math.ec.ECFieldElement;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class X9Test
implements Test {
    private byte[] namedPub = Base64.decode("MBowEwYHKoZIzj0CAQYIKoZIzj0DAQEDAwACAQ==");
    private byte[] expPub = Base64.decode("MIHcMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEDAwACAQ==");
    private byte[] namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
    private byte[] expPriv = Base64.decode("MIHkAgEAMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEECDAGAgEBBAEU");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TestResult encodePublicKey() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)))).getDERObject();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        if (!this.isSameAs(subjectPublicKeyInfo.getEncoded(), this.namedPub)) {
            return new SimpleTestResult(false, this.getName() + ": failed public named generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPub));
        DERObject dERObject = aSN1InputStream.readObject();
        if (!subjectPublicKeyInfo.equals(dERObject)) {
            return new SimpleTestResult(false, this.getName() + ": failed public named equality");
        }
        x962Parameters = new X962Parameters(x9ECParameters);
        subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        if (!this.isSameAs(subjectPublicKeyInfo.getEncoded(), this.expPub)) {
            return new SimpleTestResult(false, this.getName() + ": failed public explicit generation");
        }
        aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPub));
        dERObject = aSN1InputStream.readObject();
        if (!subjectPublicKeyInfo.equals(dERObject)) {
            return new SimpleTestResult(false, this.getName() + ": failed public explicit equality");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private TestResult encodePrivateKey() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)))).getDERObject();
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKeyStructure(BigInteger.valueOf(10L)).getDERObject());
        if (!this.isSameAs(privateKeyInfo.getEncoded(), this.namedPriv)) {
            return new SimpleTestResult(false, this.getName() + ": failed private named generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPriv));
        DERObject dERObject = aSN1InputStream.readObject();
        if (!privateKeyInfo.equals(dERObject)) {
            return new SimpleTestResult(false, this.getName() + ": failed private named equality");
        }
        x962Parameters = new X962Parameters(x9ECParameters);
        privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKeyStructure(BigInteger.valueOf(20L)).toASN1Object());
        if (!this.isSameAs(privateKeyInfo.getEncoded(), this.expPriv)) {
            return new SimpleTestResult(false, this.getName() + ": failed private explicit generation");
        }
        aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPriv));
        dERObject = aSN1InputStream.readObject();
        if (!privateKeyInfo.equals(dERObject)) {
            return new SimpleTestResult(false, this.getName() + ": failed private explicit equality");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        try {
            TestResult testResult = this.encodePublicKey();
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            return this.encodePrivateKey();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed - exception " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] stringArray) {
        X9Test x9Test = new X9Test();
        TestResult testResult = x9Test.perform();
        System.out.println(testResult);
    }
}

