/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.AttributeCertificateInfo;

public class AttributeCertificate
extends ASN1Encodable {
    AttributeCertificateInfo acinfo;
    AlgorithmIdentifier signatureAlgorithm;
    DERBitString signatureValue;

    public static AttributeCertificate getInstance(Object object) {
        if (object instanceof AttributeCertificate) {
            return (AttributeCertificate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AttributeCertificate((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AttributeCertificate(AttributeCertificateInfo attributeCertificateInfo, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString) {
        this.acinfo = attributeCertificateInfo;
        this.signatureAlgorithm = algorithmIdentifier;
        this.signatureValue = dERBitString;
    }

    public AttributeCertificate(ASN1Sequence aSN1Sequence) {
        this.acinfo = AttributeCertificateInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.signatureValue = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public AttributeCertificateInfo getAcinfo() {
        return this.acinfo;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignatureValue() {
        return this.signatureValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.acinfo);
        aSN1EncodableVector.add(this.signatureAlgorithm);
        aSN1EncodableVector.add(this.signatureValue);
        return new DERSequence(aSN1EncodableVector);
    }
}

