/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.DistributionPoint;

public class CRLDistPoint
extends ASN1Encodable {
    ASN1Sequence seq = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CRLDistPoint getInstance(Object object) {
        if (object instanceof CRLDistPoint) {
            return (CRLDistPoint)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CRLDistPoint((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CRLDistPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public CRLDistPoint(DistributionPoint[] distributionPointArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n != distributionPointArray.length) {
            aSN1EncodableVector.add(distributionPointArray[n]);
            ++n;
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] distributionPointArray = new DistributionPoint[this.seq.size()];
        int n = 0;
        while (n != this.seq.size()) {
            distributionPointArray[n] = DistributionPoint.getInstance(this.seq.getObjectAt(n));
            ++n;
        }
        return distributionPointArray;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

