/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x509.X509Name;

public class GeneralName
extends ASN1Encodable {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;

    public GeneralName(X509Name x509Name) {
        this.obj = x509Name;
        this.tag = 4;
    }

    public GeneralName(DERObject dERObject, int n) {
        this.obj = dERObject;
        this.tag = n;
    }

    public GeneralName(int n, ASN1Encodable aSN1Encodable) {
        this.obj = aSN1Encodable;
        this.tag = n;
    }

    public GeneralName(int n, String string) {
        if (n == 1 || n == 2 || n == 6) {
            this.tag = n;
            this.obj = new DERIA5String(string);
        } else if (n == 8) {
            this.tag = n;
            this.obj = new DERObjectIdentifier(string);
        } else {
            throw new IllegalArgumentException("can't process String for tag: " + n);
        }
    }

    public static GeneralName getInstance(Object object) {
        if (object == null || object instanceof GeneralName) {
            return (GeneralName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            int n = aSN1TaggedObject.getTagNo();
            switch (n) {
                case 0: {
                    return new GeneralName(aSN1TaggedObject.getObject(), n);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + n);
                }
                case 4: {
                    return new GeneralName(aSN1TaggedObject.getObject(), n);
                }
                case 5: {
                    return new GeneralName(aSN1TaggedObject.getObject(), n);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(aSN1TaggedObject, false), n);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(aSN1TaggedObject, false), n);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(aSN1TaggedObject, false), n);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, bl));
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

