/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.GeneralNames;

public class IssuerSerial
extends ASN1Encodable {
    GeneralNames issuer;
    DERInteger serial;
    DERBitString issuerUID;

    public static IssuerSerial getInstance(Object object) {
        if (object == null || object instanceof GeneralNames) {
            return (IssuerSerial)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IssuerSerial((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static IssuerSerial getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return IssuerSerial.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public IssuerSerial(ASN1Sequence aSN1Sequence) {
        this.issuer = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
        this.serial = (DERInteger)aSN1Sequence.getObjectAt(1);
        if (aSN1Sequence.size() == 3) {
            this.issuerUID = (DERBitString)aSN1Sequence.getObjectAt(2);
        }
    }

    public IssuerSerial(GeneralNames generalNames, DERInteger dERInteger) {
        this.issuer = generalNames;
        this.serial = dERInteger;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.issuer);
        aSN1EncodableVector.add(this.serial);
        if (this.issuerUID != null) {
            aSN1EncodableVector.add(this.issuerUID);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

