/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class X509NameEntryConverter {
    protected DERObject convertHexEncoded(String string, int n) throws IOException {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        while (n2 != byArray.length) {
            char c = string.charAt(n2 * 2 + n);
            char c2 = string.charAt(n2 * 2 + n + 1);
            byArray[n2] = c < 'a' ? (byte)(c - 48 << 4) : (byte)(c - 97 + 10 << 4);
            if (c2 < 'a') {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] | (byte)(c2 - 48));
            } else {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | (byte)(c2 - 97 + 10));
            }
            ++n2;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (string.charAt(n) > '\u007f') {
                return false;
            }
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9')) {
                switch (c) {
                    case ' ': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case ':': 
                    case '=': 
                    case '?': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            --n;
        }
        return true;
    }

    protected boolean canBeUTF8(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u00ff') {
                return false;
            }
            --n;
        }
        return true;
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

