/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.DHKeyGenerationParameters;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        int n = this.param.getStrength() - 1;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHParameters.getP();
        BigInteger bigInteger2 = dHParameters.getG();
        BigInteger bigInteger3 = new BigInteger(n, this.param.getRandom());
        BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger4, dHParameters), new DHPrivateKeyParameters(bigInteger3, dHParameters));
    }
}

