/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.DerivationFunction;
import cn.com.infosec.crypto.DerivationParameters;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.params.KDFParameters;

public class KDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public KDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for KDF2Generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.shared = kDFParameters.getSharedSecret();
        this.iv = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n2 < n) {
            throw new DataLengthException("output buffer too small");
        }
        long l = n2 * 8;
        if (l > (long)(this.digest.getDigestSize() * 8) * 29L) {
            new IllegalArgumentException("Output length to large");
        }
        int n3 = (int)(l / (long)this.digest.getDigestSize());
        byte[] byArray2 = null;
        byArray2 = new byte[this.digest.getDigestSize()];
        int n4 = 1;
        while (n4 <= n3) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(n4 & 0xFF));
            this.digest.update((byte)(n4 >> 8 & 0xFF));
            this.digest.update((byte)(n4 >> 16 & 0xFF));
            this.digest.update((byte)(n4 >> 24 & 0xFF));
            this.digest.update(this.iv, 0, this.iv.length);
            this.digest.doFinal(byArray2, 0);
            if (n2 - n > byArray2.length) {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            } else {
                System.arraycopy(byArray2, 0, byArray, n, n2 - n);
            }
            ++n4;
        }
        this.digest.reset();
        return n2;
    }
}

