/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.modes;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;

public class OpenPGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private byte[] tmp;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;

    public OpenPGPCFBBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.FR = new byte[this.blockSize];
        this.FRE = new byte[this.blockSize];
        this.tmp = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OpenPGPCFB";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    public void reset() {
        this.count = 0;
        int n = 0;
        while (n != this.FR.length) {
            this.FR[n] = this.IV[n];
            ++n;
        }
        this.cipher.reset();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(true, cipherParameters);
    }

    private byte encryptByte(byte by, int n) {
        return (byte)(this.FRE[n] ^ by);
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count > this.blockSize) {
            this.FR[this.blockSize - 2] = byArray2[n2] = this.encryptByte(byArray[n], this.blockSize - 2);
            byte by = this.encryptByte(byArray[n + 1], this.blockSize - 1);
            byArray2[n2 + 1] = by;
            this.FR[this.blockSize - 1] = by;
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n3 = 2;
            while (n3 < this.blockSize) {
                byArray2[n2 + n3] = this.encryptByte(byArray[n + n3], n3 - 2);
                ++n3;
            }
            System.arraycopy(byArray2, n2 + 2, this.FR, 0, this.blockSize - 2);
        } else if (this.count == 0) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n4 = 0;
            while (n4 < this.blockSize) {
                byArray2[n2 + n4] = this.encryptByte(byArray[n + n4], n4);
                ++n4;
            }
            System.arraycopy(byArray2, n2, this.FR, 0, this.blockSize);
            this.count += this.blockSize;
        } else if (this.count == this.blockSize) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byArray2[n2] = this.encryptByte(byArray[n], 0);
            byArray2[n2 + 1] = this.encryptByte(byArray[n + 1], 1);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            System.arraycopy(byArray2, n2, this.FR, this.blockSize - 2, 2);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n5 = 2;
            while (n5 < this.blockSize) {
                byArray2[n2 + n5] = this.encryptByte(byArray[n + n5], n5 - 2);
                ++n5;
            }
            System.arraycopy(byArray2, n2 + 2, this.FR, 0, this.blockSize - 2);
            this.count += this.blockSize;
        }
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count > this.blockSize) {
            System.arraycopy(byArray, n, this.tmp, 0, this.blockSize);
            byArray2[n2 + 0] = this.encryptByte(this.tmp[0], this.blockSize - 2);
            byArray2[n2 + 1] = this.encryptByte(this.tmp[1], this.blockSize - 1);
            System.arraycopy(this.tmp, 0, this.FR, this.blockSize - 2, 2);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n3 = 2;
            while (n3 < this.blockSize) {
                byArray2[n2 + n3] = this.encryptByte(this.tmp[n3], n3 - 2);
                ++n3;
            }
            System.arraycopy(this.tmp, 2, this.FR, 0, this.blockSize - 2);
        } else if (this.count == 0) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n4 = 0;
            while (n4 < this.blockSize) {
                this.FR[n4] = byArray[n + n4];
                byArray2[n4] = this.encryptByte(byArray[n + n4], n4);
                ++n4;
            }
            this.count += this.blockSize;
        } else if (this.count == this.blockSize) {
            System.arraycopy(byArray, n, this.tmp, 0, this.blockSize);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byArray2[n2 + 0] = this.encryptByte(this.tmp[0], 0);
            byArray2[n2 + 1] = this.encryptByte(this.tmp[1], 1);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            this.FR[this.blockSize - 2] = this.tmp[0];
            this.FR[this.blockSize - 1] = this.tmp[1];
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n5 = 2;
            while (n5 < this.blockSize) {
                this.FR[n5 - 2] = byArray[n + n5];
                byArray2[n2 + n5] = this.encryptByte(byArray[n + n5], n5 - 2);
                ++n5;
            }
            this.count += this.blockSize;
        }
        return this.blockSize;
    }
}

