/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.BufferedBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.engines.DESEngine;
import cn.com.infosec.crypto.engines.SkipjackEngine;
import cn.com.infosec.crypto.modes.CBCBlockCipher;
import cn.com.infosec.crypto.modes.CTSBlockCipher;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class CTSTest
implements Test {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    CTSTest() {
    }

    public String getName() {
        return "CTS";
    }

    public TestResult perform() {
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        CTSTester cTSTester = new CTSTester(1, new DESEngine(), new KeyParameter(byArray), in1, out1);
        TestResult testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        cTSTester = new CTSTester(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(byArray), byArray3), in1, out2);
        testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        cTSTester = new CTSTester(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(byArray2), byArray3), in2, out3);
        testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        CTSTest cTSTest = new CTSTest();
        TestResult testResult = cTSTest.perform();
        System.out.println(testResult);
    }

    private class CTSTester
    implements Test {
        private int id;
        private BlockCipher cipher;
        private CipherParameters params;
        private byte[] input;
        private byte[] output;

        CTSTester(int n, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) {
            this.id = n;
            this.cipher = blockCipher;
            this.params = cipherParameters;
            this.input = byArray;
            this.output = byArray2;
        }

        public String getName() {
            return "CTSTest " + this.id;
        }

        public TestResult perform() {
            byte[] byArray = new byte[this.input.length];
            CTSBlockCipher cTSBlockCipher = new CTSBlockCipher(this.cipher);
            cTSBlockCipher.init(true, this.params);
            int n = ((BufferedBlockCipher)cTSBlockCipher).processBytes(this.input, 0, this.input.length, byArray, 0);
            try {
                ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, n);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": encryption exception - " + exception.toString());
            }
            int n2 = 0;
            while (n2 != this.output.length) {
                if (byArray[n2] != this.output[n2]) {
                    return new SimpleTestResult(false, this.getName() + ": failed encryption expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(byArray)));
                }
                ++n2;
            }
            cTSBlockCipher.init(false, this.params);
            n = ((BufferedBlockCipher)cTSBlockCipher).processBytes(this.output, 0, this.output.length, byArray, 0);
            try {
                ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, n);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": decryption exception - " + exception.toString());
            }
            int n3 = 0;
            while (n3 != this.input.length) {
                if (byArray[n3] != this.input[n3]) {
                    return new SimpleTestResult(false, this.getName() + ": failed encryption expected " + new String(Hex.encode(this.input)) + " got " + new String(Hex.encode(byArray)));
                }
                ++n3;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }
}

