/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.engines.DESedeEngine;
import cn.com.infosec.crypto.engines.DESedeWrapEngine;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.crypto.test.BlockCipherVectorTest;
import cn.com.infosec.crypto.test.CipherTest;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class DESedeTest
extends CipherTest {
    static String input1 = "4e6f77206973207468652074696d6520666f7220616c6c20";
    static String input2 = "4e6f7720697320746865";
    static Test[] tests = new Test[]{new BlockCipherVectorTest(0, new DESedeEngine(), new KeyParameter(Hex.decode("0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(1, new DESedeEngine(), new KeyParameter(Hex.decode("0123456789abcdeffedcba9876543210")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c"), new BlockCipherVectorTest(2, new DESedeEngine(), new KeyParameter(Hex.decode("0123456789abcdef0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(3, new DESedeEngine(), new KeyParameter(Hex.decode("0123456789abcdeffedcba98765432100123456789abcdef")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c")};

    DESedeTest() {
        super(tests);
    }

    private TestResult wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5;
        DESedeWrapEngine dESedeWrapEngine = new DESedeWrapEngine();
        dESedeWrapEngine.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        try {
            byArray5 = dESedeWrapEngine.wrap(byArray3, 0, byArray3.length);
            if (!Arrays.areEqual(byArray5, byArray4)) {
                return new SimpleTestResult(false, this.getName() + ": failed wrap test " + n + " expected " + new String(Hex.encode(byArray4)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + exception.toString());
        }
        dESedeWrapEngine.init(false, new KeyParameter(byArray));
        try {
            byArray5 = dESedeWrapEngine.unwrap(byArray4, 0, byArray4.length);
            if (!Arrays.areEqual(byArray5, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        TestResult testResult = super.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray4 = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
        testResult = this.wrapTest(1, byArray4, byArray3 = Hex.decode("5dd4cbfc96f5453b"), byArray2 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98"), byArray = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "DESede";
    }

    public static void main(String[] stringArray) {
        DESedeTest dESedeTest = new DESedeTest();
        TestResult testResult = dESedeTest.perform();
        System.out.println(testResult);
    }
}

