/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.BufferedBlockCipher;
import cn.com.infosec.crypto.agreement.ECDHBasicAgreement;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.engines.IESEngine;
import cn.com.infosec.crypto.engines.TwofishEngine;
import cn.com.infosec.crypto.generators.ECKeyPairGenerator;
import cn.com.infosec.crypto.generators.KDF2BytesGenerator;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.crypto.modes.CBCBlockCipher;
import cn.com.infosec.crypto.paddings.PaddedBufferedBlockCipher;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.IESParameters;
import cn.com.infosec.crypto.params.IESWithCipherParameters;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESTest
implements Test {
    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        Object object;
        Object object2;
        SecureRandom secureRandom = new SecureRandom();
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters iESParameters = new IESParameters(byArray, byArray2, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byte[] byArray3 = Hex.decode("1234567890abcdef");
        try {
            object2 = iESEngine.processBlock(byArray3, 0, byArray3.length);
            object = iESEngine2.processBlock((byte[])object2, 0, ((byte[])object2).length);
            if (!this.sameAs((byte[])object, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        object2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        object = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), (BufferedBlockCipher)object2);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), (BufferedBlockCipher)object);
        byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        iESParameters = new IESWithCipherParameters(byArray, byArray2, 64, 128);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byArray3 = Hex.decode("1234567890abcdef");
        try {
            byte[] byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
            byte[] byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
            if (!this.sameAs(byArray5, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": twofish cipher test failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": twofish cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        ECIESTest eCIESTest = new ECIESTest();
        TestResult testResult = eCIESTest.perform();
        System.out.println(testResult);
    }
}

