/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.digests.MD5Digest;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class MD5HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"9294727a3638bb1c13f48ef8158bfc9d", "750c783e6ab0b503eaa86e310a5db738", "56be34521d144c88dbb8c733f0e8b3f6", "697eaf0aca3a3aea3a75164746ffaa79", "56461ef2342edc00f9bab995690efd4c", "6b1ab7fe4bd7bf8f0b62e6ce61b9d0cd", "6f630fad67cda0ee1fb1f562db3aa53e"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"};

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "MD5HMac";
    }

    public TestResult perform() {
        HMac hMac = new HMac(new MD5Digest());
        byte[] byArray = new byte[hMac.getMacSize()];
        int n = 0;
        while (n < messages.length) {
            byte[] byArray2 = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray2 = Hex.decode(messages[n].substring(2));
            }
            hMac.init(new KeyParameter(Hex.decode(keys[n])));
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray, 0);
            if (!MD5HMacTest.arraysEqual(byArray, Hex.decode(digests[n]))) {
                return new SimpleTestResult(false, this.getName() + "Vector " + n + " failed");
            }
            ++n;
        }
        int n2 = 0;
        byte[] byArray3 = messages[n2].getBytes();
        if (messages[n2].startsWith("0x")) {
            byArray3 = Hex.decode(messages[n2].substring(2));
        }
        hMac.init(new KeyParameter(Hex.decode(keys[n2])));
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        hMac.reset();
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        if (!MD5HMacTest.arraysEqual(byArray, Hex.decode(digests[n2]))) {
            return new SimpleTestResult(false, this.getName() + "Reset with vector " + n2 + " failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        MD5HMacTest mD5HMacTest = new MD5HMacTest();
        TestResult testResult = mD5HMacTest.perform();
        System.out.println(testResult);
    }
}

