/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.Mac;
import cn.com.infosec.crypto.engines.DESEngine;
import cn.com.infosec.crypto.macs.CBCBlockCipherMac;
import cn.com.infosec.crypto.macs.CFBBlockCipherMac;
import cn.com.infosec.crypto.paddings.PKCS7Padding;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class MacTest
implements Test {
    static byte[] keyBytes = Hex.decode("0123456789abcdef");
    static byte[] ivBytes = Hex.decode("1234567890abcdef");
    static byte[] input1 = Hex.decode("37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode("f1d30f68");
    static byte[] output2 = Hex.decode("58d2e77e");
    static byte[] output3 = Hex.decode("cd647403");
    static byte[] input2 = Hex.decode("3736353433323120");
    static byte[] output4 = Hex.decode("3af549c9");
    static byte[] output5 = Hex.decode("188fbdd5");
    static byte[] output6 = Hex.decode("7045eecd");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        KeyParameter keyParameter = new KeyParameter(keyBytes);
        DESEngine dESEngine = new DESEngine();
        Mac mac = new CBCBlockCipherMac(dESEngine);
        mac.init(keyParameter);
        mac.update(input1, 0, input1.length);
        byte[] byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output1)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, ivBytes);
        mac.init(parametersWithIV);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output2)) + " got " + new String(Hex.encode(byArray)));
        }
        parametersWithIV = new ParametersWithIV(keyParameter, ivBytes);
        mac = new CFBBlockCipherMac(dESEngine);
        mac.init(parametersWithIV);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output3)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output3)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.init(keyParameter);
        mac.update(input2, 0, input2.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output4)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output4)) + " got " + new String(Hex.encode(byArray)));
        }
        mac = new CBCBlockCipherMac((BlockCipher)dESEngine, new PKCS7Padding());
        mac.init(keyParameter);
        mac.update(input2, 0, input2.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output5)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output5)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.reset();
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output6)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.init(keyParameter);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output6)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(byArray)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] stringArray) {
        MacTest macTest = new MacTest();
        TestResult testResult = macTest.perform();
        System.out.println(testResult);
    }
}

