/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.engines.DESEngine;
import cn.com.infosec.crypto.modes.CFBBlockCipher;
import cn.com.infosec.crypto.modes.OFBBlockCipher;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class ModeTest
implements Test {
    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] byArray = Hex.decode("4e6f7720");
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        OFBBlockCipher oFBBlockCipher = new OFBBlockCipher(new DESEngine(), 32);
        oFBBlockCipher.init(true, new ParametersWithIV(keyParameter, Hex.decode("1122334455667788")));
        oFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        oFBBlockCipher.init(false, new ParametersWithIV(keyParameter, Hex.decode("1122334455667788")));
        oFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": test 1 - in != out");
        }
        oFBBlockCipher.init(true, new ParametersWithIV(keyParameter, Hex.decode("11223344")));
        oFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        oFBBlockCipher.init(false, new ParametersWithIV(keyParameter, Hex.decode("0000000011223344")));
        oFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": test 2 - in != out");
        }
        CFBBlockCipher cFBBlockCipher = new CFBBlockCipher(new DESEngine(), 32);
        cFBBlockCipher.init(true, new ParametersWithIV(keyParameter, Hex.decode("1122334455667788")));
        cFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        cFBBlockCipher.init(false, new ParametersWithIV(keyParameter, Hex.decode("1122334455667788")));
        cFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": test 3 - in != out");
        }
        cFBBlockCipher.init(true, new ParametersWithIV(keyParameter, Hex.decode("11223344")));
        cFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        cFBBlockCipher.init(false, new ParametersWithIV(keyParameter, Hex.decode("0000000011223344")));
        cFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": test 4 - in != out");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "ModeTest";
    }

    public static void main(String[] stringArray) {
        ModeTest modeTest = new ModeTest();
        TestResult testResult = modeTest.perform();
        System.out.println(testResult);
    }
}

