/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.engines.DESEngine;
import cn.com.infosec.crypto.paddings.BlockCipherPadding;
import cn.com.infosec.crypto.paddings.ISO10126d2Padding;
import cn.com.infosec.crypto.paddings.PKCS7Padding;
import cn.com.infosec.crypto.paddings.PaddedBufferedBlockCipher;
import cn.com.infosec.crypto.paddings.TBCPadding;
import cn.com.infosec.crypto.paddings.X923Padding;
import cn.com.infosec.crypto.paddings.ZeroBytePadding;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.security.SecureRandom;

public class PaddingTest
implements Test {
    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TestResult blockCheck(PaddedBufferedBlockCipher paddedBufferedBlockCipher, BlockCipherPadding blockCipherPadding, KeyParameter keyParameter, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        byte[] byArray3 = new byte[byArray.length];
        try {
            paddedBufferedBlockCipher.init(true, keyParameter);
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray2, n);
            paddedBufferedBlockCipher.init(false, keyParameter);
            int n2 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n, byArray3, 0);
            n2 += paddedBufferedBlockCipher.doFinal(byArray3, n2);
            if (!this.isEqualTo(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": failed to decrypt - i = " + byArray.length + ", padding = " + blockCipherPadding.getPaddingName());
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] byArray3 = new byte[]{-1, -1, -1, 0, 0, 0, 0, 0};
        if (byArray != null) {
            blockCipherPadding.addPadding(byArray3, 3);
            if (!this.isEqualTo(byArray3, byArray)) {
                return new SimpleTestResult(false, this.getName() + ": failed ff test for " + blockCipherPadding.getPaddingName());
            }
        }
        if (byArray2 != null) {
            byArray3 = new byte[8];
            blockCipherPadding.addPadding(byArray3, 4);
            if (!this.isEqualTo(byArray3, byArray2)) {
                return new SimpleTestResult(false, this.getName() + ": failed zero test for " + blockCipherPadding.getPaddingName());
            }
        }
        int n = 1;
        while (n != 200) {
            byArray3 = new byte[n];
            secureRandom.nextBytes(byArray3);
            TestResult testResult = this.blockCheck(paddedBufferedBlockCipher, blockCipherPadding, keyParameter, byArray3);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            ++n;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        SecureRandom secureRandom = new SecureRandom(new byte[20]);
        secureRandom.setSeed(System.currentTimeMillis());
        TestResult testResult = this.testPadding(new PKCS7Padding(), secureRandom, Hex.decode("ffffff0505050505"), Hex.decode("0000000004040404"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding(new ISO10126d2Padding(), secureRandom, null, null);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding(new X923Padding(), secureRandom, null, null);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding(new TBCPadding(), secureRandom, Hex.decode("ffffff0000000000"), Hex.decode("00000000ffffffff"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding(new ZeroBytePadding(), secureRandom, Hex.decode("ffffff0000000000"), null);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] stringArray) {
        PaddingTest paddingTest = new PaddingTest();
        TestResult testResult = paddingTest.perform();
        System.out.println(testResult);
    }
}

