/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.digests.RIPEMD160Digest;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class RIPEMD160DigestTest
implements Test {
    static final String[] messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
    static final String[] digests = new String[]{"9c1185a5c5e9fc54612808977ee8f548b2258d31", "0bdc9d2d256b3ee9daae347be6f4dc835a467ffe", "8eb208f7e05d987a9b044a8e98c6b087f15a0bfc", "5d0689ef49d2fae572b881b123a85ffa21595f36", "f71c27109c692c1b56bbdceb5b9d2865b3708dbc", "12a053384a9c0c88e405a06c27dcf49ada62eb2b", "b0e20b6e3116640286ed3a87a5713079b21f5189", "9b752e45573d4b39f4dbd3323cab82bf63326bfb"};
    static final String million_a_digest = "52783243c1697bdbe16d37f97f68f08325dc1528";

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "RIPEMD160";
    }

    public TestResult perform() {
        byte[] byArray;
        RIPEMD160Digest rIPEMD160Digest = new RIPEMD160Digest();
        byte[] byArray2 = new byte[rIPEMD160Digest.getDigestSize()];
        int n = 0;
        while (n < messages.length) {
            byArray = messages[n].getBytes();
            rIPEMD160Digest.update(byArray, 0, byArray.length);
            rIPEMD160Digest.doFinal(byArray2, 0);
            if (!RIPEMD160DigestTest.arraysEqual(byArray2, Hex.decode(digests[n]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed");
            }
            ++n;
        }
        byArray = messages[messages.length - 1].getBytes();
        rIPEMD160Digest.update(byArray, 0, byArray.length / 2);
        RIPEMD160Digest rIPEMD160Digest2 = new RIPEMD160Digest(rIPEMD160Digest);
        rIPEMD160Digest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD160Digest.doFinal(byArray2, 0);
        if (!RIPEMD160DigestTest.arraysEqual(byArray2, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD160 failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(byArray2)));
        }
        rIPEMD160Digest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD160Digest2.doFinal(byArray2, 0);
        if (!RIPEMD160DigestTest.arraysEqual(byArray2, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD160 failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(byArray2)));
        }
        int n2 = 0;
        while (n2 < 1000000) {
            rIPEMD160Digest.update((byte)97);
            ++n2;
        }
        rIPEMD160Digest.doFinal(byArray2, 0);
        if (!RIPEMD160DigestTest.arraysEqual(byArray2, Hex.decode(million_a_digest))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        RIPEMD160DigestTest rIPEMD160DigestTest = new RIPEMD160DigestTest();
        TestResult testResult = rIPEMD160DigestTest.perform();
        System.out.println(testResult);
    }
}

