/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptAlgException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PKCS7EnvelopedData
implements PKCSObjectIdentifiers {
    public static SecretKey key;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    public static final int RC4 = 4;
    public static final int IV_LENGTH = 8;
    private static final String OID_ENVELOPEDDATATYPE = "1.2.840.113549.1.7.3";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";

    public byte[] decrypt(byte[] byArray, Certificate certificate, PrivateKey privateKey) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException {
        Object object;
        DERObject dERObject;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        DERConstructedSequence dERConstructedSequence = null;
        try {
            dERObject = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        if (!(dERObject instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo contentInfo = ContentInfo.getInstance(dERObject);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.envelopedData)) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header " + contentInfo.getContentType().getId());
        }
        dERConstructedSequence = (DERConstructedSequence)dERObject;
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)DERConstructedSequence.getInstance((DERTaggedObject)dERConstructedSequence.getObjectAt(1), true);
        DERConstructedSet dERConstructedSet = (DERConstructedSet)DERSet.getInstance(dERConstructedSequence2.getObjectAt(1));
        DERConstructedSequence dERConstructedSequence3 = (DERConstructedSequence)DERConstructedSequence.getInstance(dERConstructedSet.getObjectAt(0));
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(dERConstructedSequence3.getObjectAt(1));
        String string = issuerAndSerialNumber.getName().toString();
        String string2 = issuerAndSerialNumber.getCertificateSerialNumber().getValue().toString(10);
        String string3 = ((X509Certificate)certificate).getIssuerDN().toString();
        String string4 = ((X509Certificate)certificate).getSerialNumber().toString(10);
        if (!string3.equals(string) || !string4.equals(string2)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        DEROctetString dEROctetString = (DEROctetString)dERConstructedSequence3.getObjectAt(3);
        DERConstructedSequence dERConstructedSequence4 = (DERConstructedSequence)DERConstructedSequence.getInstance(dERConstructedSequence2.getObjectAt(2));
        AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(dERConstructedSequence4.getObjectAt(1));
        String string5 = PKCS7EnvelopedData.getAlgName(algorithmIdentifier.getObjectId().getId());
        DEROctetString dEROctetString2 = (DEROctetString)algorithmIdentifier.getParameters();
        IvParameterSpec ivParameterSpec = null;
        if (dEROctetString2 != null) {
            ivParameterSpec = new IvParameterSpec(dEROctetString2.getOctets());
        }
        DEROctetString dEROctetString3 = (DEROctetString)DEROctetString.getInstance((DERTaggedObject)dERConstructedSequence4.getObjectAt(2), true);
        byte[] byArray2 = null;
        try {
            object = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
            ((Cipher)object).init(2, privateKey);
            byArray2 = ((Cipher)object).doFinal(dEROctetString.getOctets());
        }
        catch (Exception exception) {
            throw new DecryptKeyException("decrypt key error!");
        }
        object = null;
        try {
            Cipher cipher = Cipher.getInstance(string5, "INFOSEC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string5);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            object = cipher.doFinal(dEROctetString3.getOctets());
        }
        catch (Exception exception) {
            throw new DecryptDataException("decrypt data error!");
        }
        return object;
    }

    public byte[] encrypt(byte[] byArray, Certificate certificate, int n) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        DERInteger dERInteger = new DERInteger(0);
        DERInteger dERInteger2 = new DERInteger(0);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(new X509Name(((X509Certificate)certificate).getIssuerDN().toString()), new DERInteger(((X509Certificate)certificate).getSerialNumber()));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(OID_RSA_ECB_PKCS1PADDING), null);
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(PKCS7EnvelopedData.getKeyGenAlgName(n), "INFOSEC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] byArray2 = secretKey.getEncoded();
        PublicKey publicKey = certificate.getPublicKey();
        Cipher cipher = null;
        byte[] byArray3 = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
            cipher.init(1, publicKey);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString dEROctetString = new DEROctetString(byArray3);
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(dERInteger2);
        dERConstructedSequence.addObject(issuerAndSerialNumber);
        dERConstructedSequence.addObject(algorithmIdentifier);
        dERConstructedSequence.addObject(dEROctetString);
        DERSet dERSet = new DERSet(dERConstructedSequence);
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier algorithmIdentifier2 = PKCS7EnvelopedData.getAlgorithmIdentifier(n);
        DERObject dERObject = (DERObject)algorithmIdentifier2.getParameters();
        IvParameterSpec ivParameterSpec = null;
        if (dERObject != null) {
            ivParameterSpec = new IvParameterSpec(((DEROctetString)dERObject).getOctets());
        }
        byte[] byArray4 = null;
        try {
            cipher = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(n), "INFOSEC");
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            byArray4 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new EncryptDataException("encrypt data error");
        }
        DERTaggedObject dERTaggedObject = new DERTaggedObject(true, 0, new DEROctetString(byArray4));
        DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
        dERConstructedSequence2.addObject(dERObjectIdentifier);
        dERConstructedSequence2.addObject(algorithmIdentifier2);
        dERConstructedSequence2.addObject(dERTaggedObject);
        DERConstructedSequence dERConstructedSequence3 = new DERConstructedSequence();
        dERConstructedSequence3.addObject(dERInteger);
        dERConstructedSequence3.addObject(dERSet);
        dERConstructedSequence3.addObject(dERConstructedSequence2);
        String string = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence dERConstructedSequence4 = new DERConstructedSequence();
        dERConstructedSequence4.addObject(new DERObjectIdentifier(string));
        DERTaggedObject dERTaggedObject2 = new DERTaggedObject(true, 0, dERConstructedSequence3);
        dERConstructedSequence4.addObject(dERTaggedObject2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(dERConstructedSequence4);
        }
        catch (IOException iOException) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return byArray5;
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier(int n) {
        Object object;
        String string = null;
        boolean bl = false;
        if (n == 4) {
            string = "1.2.840.113549.3.4";
            bl = false;
        } else if (n == 3) {
            string = "1.2.840.113549.3.2";
            bl = true;
        } else if (n == 1) {
            string = "1.2.840.113549.3.7";
            bl = true;
        } else if (n == 2) {
            string = "1.3.14.3.2.7";
            bl = true;
        }
        DEROctetString dEROctetString = null;
        if (bl) {
            object = new byte[8];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes((byte[])object);
            dEROctetString = new DEROctetString((byte[])object);
        }
        object = new AlgorithmIdentifier(new DERObjectIdentifier(string), dEROctetString);
        return object;
    }

    private static String getAlgName(String string) {
        String string2 = null;
        if (string.equals("1.2.840.113549.3.4")) {
            string2 = "RC4";
        } else if (string.equals("1.3.14.3.2.7")) {
            string2 = "DES/CBC";
        } else if (string.equals("1.2.840.113549.3.7")) {
            string2 = "DESede/CBC";
        } else if (string.equals("1.2.840.113549.3.2")) {
            string2 = "RC2/CBC";
        }
        return string2;
    }

    private static String getAlgName(int n) {
        String string = null;
        if (n == 4) {
            string = "RC4";
        } else if (n == 2) {
            string = "DES/CBC";
        } else if (n == 1) {
            string = "DESede/CBC";
        } else if (n == 3) {
            string = "RC2/CBC";
        }
        return string;
    }

    private static String getKeyGenAlgName(int n) {
        String string = "";
        if (n == 4) {
            string = "RC4";
        } else if (n == 3) {
            string = "RC2";
        } else if (n == 2) {
            string = "DES";
        } else if (n == 1) {
            string = "DESEDE";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        try {
            Object object;
            PKCS7EnvelopedData pKCS7EnvelopedData = new PKCS7EnvelopedData();
            FileInputStream fileInputStream = new FileInputStream("d:\\ttt.pfx");
            char[] cArray = new char[]{'1', '1', '1', '1', '1', '1', '1', '1'};
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "INFOSEC");
            keyStore.load(fileInputStream, cArray);
            Enumeration<String> enumeration = keyStore.aliases();
            Object object2 = null;
            Object object3 = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (keyStore.isKeyEntry((String)object)) {
                    object2 = object;
                }
                if (!keyStore.isCertificateEntry((String)object)) continue;
                object3 = object;
            }
            fileInputStream.close();
            object = (X509Certificate)keyStore.getCertificate((String)object2);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey((String)object2, "".toCharArray());
            byte[] byArray = "This is a Test".getBytes();
            System.out.println("====================");
            long l = System.currentTimeMillis();
            byte[] byArray2 = null;
            int n = 0;
            while (n < 100) {
                byArray2 = pKCS7EnvelopedData.encrypt(byArray, (Certificate)object, 4);
                ++n;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("time=" + (l2 - l));
            FileOutputStream fileOutputStream = new FileOutputStream("d:\\testenv.dat");
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

