/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ECPoint;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.jce.interfaces.ECPointEncoder;
import cn.com.infosec.jce.interfaces.ECPublicKey;
import cn.com.infosec.jce.spec.ECNamedCurveParameterSpec;
import cn.com.infosec.jce.spec.ECParameterSpec;
import cn.com.infosec.jce.spec.ECPublicKeySpec;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private Object ecSpec;
    private boolean withCompression = true;

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        this.ecSpec = eCPublicKeySpec.getParams();
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPublicKey(String string, ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        ECCurve eCCurve;
        Object object2;
        ASN1Encodable aSN1Encodable;
        X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            object2 = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
            this.ecSpec = new ECNamedCurveParameterSpec(X962NamedCurves.getName((DERObjectIdentifier)aSN1Encodable), ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), ((X9ECParameters)object2).getSeed());
            eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
        }
        aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
        object2 = ((DERBitString)aSN1Encodable).getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            try {
                object = new ByteArrayInputStream((byte[])object2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = new X9ECPoint(eCCurve, aSN1OctetString);
        this.q = ((X9ECPoint)object).getPoint();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        ASN1Encodable aSN1Encodable;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            x962Parameters = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()));
        } else {
            object = (ECParameterSpec)this.ecSpec;
            aSN1Encodable = new X9ECParameters(((ECParameterSpec)object).getCurve(), new ECPoint.Fp(((ECParameterSpec)object).getG().getCurve(), ((ECParameterSpec)object).getG().getX(), ((ECParameterSpec)object).getG().getY(), this.withCompression), ((ECParameterSpec)object).getN(), ((ECParameterSpec)object).getH(), ((ECParameterSpec)object).getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)aSN1Encodable);
        }
        object = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(this.getQ().getCurve(), this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
        aSN1Encodable = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)object).getOctets());
        try {
            dEROutputStream.writeObject(aSN1Encodable);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.getQ().getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.getQ().getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equals(string);
    }
}

