/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Null;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.nist.NISTObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.digests.MD2Digest;
import cn.com.infosec.crypto.digests.MD4Digest;
import cn.com.infosec.crypto.digests.MD5Digest;
import cn.com.infosec.crypto.digests.RIPEMD128Digest;
import cn.com.infosec.crypto.digests.RIPEMD160Digest;
import cn.com.infosec.crypto.digests.RIPEMD256Digest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.digests.SHA224Digest;
import cn.com.infosec.crypto.digests.SHA256Digest;
import cn.com.infosec.crypto.digests.SHA384Digest;
import cn.com.infosec.crypto.digests.SHA512Digest;
import cn.com.infosec.crypto.encodings.PKCS1Encoding;
import cn.com.infosec.crypto.engines.RSAEngine;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.jce.provider.RSAUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class JDKDigestSignature
extends Signature
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private AlgorithmIdentifier algId;

    protected JDKDigestSignature(String string, DERObjectIdentifier dERObjectIdentifier, Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        super(string);
        this.digest = digest;
        this.cipher = asymmetricBlockCipher;
        this.algId = new AlgorithmIdentifier(dERObjectIdentifier, null);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.digest.reset();
        this.cipher.init(false, rSAKeyParameters);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.digest.reset();
        this.cipher.init(true, rSAKeyParameters);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.derEncode(byArray);
            return this.cipher.processBlock(byArray2, 0, byArray2.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    private boolean isNull(DEREncodable dEREncodable) {
        return dEREncodable instanceof ASN1Null || dEREncodable == null;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        DigestInfo digestInfo;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            byte[] byArray3 = this.cipher.processBlock(byArray, 0, byArray.length);
            digestInfo = this.derDecode(byArray3);
        }
        catch (Exception exception) {
            return false;
        }
        if (!digestInfo.getAlgorithmId().getObjectId().equals(this.algId.getObjectId())) {
            return false;
        }
        if (!this.isNull(digestInfo.getAlgorithmId().getParameters())) {
            return false;
        }
        byte[] byArray4 = digestInfo.getDigest();
        if (byArray2.length != byArray4.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray4[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        DigestInfo digestInfo = new DigestInfo(this.algId, byArray);
        dEROutputStream.writeObject(digestInfo);
        return byteArrayOutputStream.toByteArray();
    }

    private DigestInfo derDecode(byte[] byArray) throws IOException {
        if (byArray[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        return new DigestInfo((ASN1Sequence)aSN1InputStream.readObject());
    }

    public static class RIPEMD256WithRSAEncryption
    extends JDKDigestSignature {
        public RIPEMD256WithRSAEncryption() {
            super("RIPEMD256withRSA", TeleTrusTObjectIdentifiers.ripemd256, new RIPEMD256Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class RIPEMD128WithRSAEncryption
    extends JDKDigestSignature {
        public RIPEMD128WithRSAEncryption() {
            super("RIPEMD128withRSA", TeleTrusTObjectIdentifiers.ripemd128, new RIPEMD128Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class RIPEMD160WithRSAEncryption
    extends JDKDigestSignature {
        public RIPEMD160WithRSAEncryption() {
            super("RIPEMD160withRSA", TeleTrusTObjectIdentifiers.ripemd160, new RIPEMD160Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class MD5WithRSAEncryption
    extends JDKDigestSignature {
        public MD5WithRSAEncryption() {
            super("MD5withRSA", PKCSObjectIdentifiers.md5, new MD5Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class MD4WithRSAEncryption
    extends JDKDigestSignature {
        public MD4WithRSAEncryption() {
            super("MD4withRSA", PKCSObjectIdentifiers.md4, new MD4Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class MD2WithRSAEncryption
    extends JDKDigestSignature {
        public MD2WithRSAEncryption() {
            super("MD2withRSA", PKCSObjectIdentifiers.md2, new MD2Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class SHA512WithRSAEncryption
    extends JDKDigestSignature {
        public SHA512WithRSAEncryption() {
            super("SHA512withRSA", NISTObjectIdentifiers.id_sha512, new SHA512Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class SHA384WithRSAEncryption
    extends JDKDigestSignature {
        public SHA384WithRSAEncryption() {
            super("SHA384withRSA", NISTObjectIdentifiers.id_sha384, new SHA384Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class SHA256WithRSAEncryption
    extends JDKDigestSignature {
        public SHA256WithRSAEncryption() {
            super("SHA256withRSA", NISTObjectIdentifiers.id_sha256, new SHA256Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class SHA224WithRSAEncryption
    extends JDKDigestSignature {
        public SHA224WithRSAEncryption() {
            super("SHA224withRSA", NISTObjectIdentifiers.id_sha224, new SHA224Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class SHA1WithRSAEncryption
    extends JDKDigestSignature {
        public SHA1WithRSAEncryption() {
            super("SHA1withRSA", X509ObjectIdentifiers.id_SHA1, new SHA1Digest(), new PKCS1Encoding(new RSAEngine()));
        }
    }
}

