/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.generators.DHBasicKeyPairGenerator;
import cn.com.infosec.crypto.generators.DHParametersGenerator;
import cn.com.infosec.crypto.generators.DSAKeyPairGenerator;
import cn.com.infosec.crypto.generators.DSAParametersGenerator;
import cn.com.infosec.crypto.generators.ECKeyPairGenerator;
import cn.com.infosec.crypto.generators.ElGamalKeyPairGenerator;
import cn.com.infosec.crypto.generators.ElGamalParametersGenerator;
import cn.com.infosec.crypto.generators.RSAKeyPairGenerator;
import cn.com.infosec.crypto.params.DHKeyGenerationParameters;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import cn.com.infosec.crypto.params.DSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAPublicKeyParameters;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ElGamalKeyGenerationParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalPublicKeyParameters;
import cn.com.infosec.crypto.params.RSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.jce.ECNamedCurveTable;
import cn.com.infosec.jce.provider.JCEDHPrivateKey;
import cn.com.infosec.jce.provider.JCEDHPublicKey;
import cn.com.infosec.jce.provider.JCEECPrivateKey;
import cn.com.infosec.jce.provider.JCEECPublicKey;
import cn.com.infosec.jce.provider.JCEElGamalPrivateKey;
import cn.com.infosec.jce.provider.JCEElGamalPublicKey;
import cn.com.infosec.jce.provider.JCERSAPrivateCrtKey;
import cn.com.infosec.jce.provider.JCERSAPublicKey;
import cn.com.infosec.jce.provider.JDKDSAPrivateKey;
import cn.com.infosec.jce.provider.JDKDSAPublicKey;
import cn.com.infosec.jce.spec.ECParameterSpec;
import cn.com.infosec.jce.spec.ElGamalParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String string) {
        super(string);
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends JDKKeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        ECParameterSpec ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String string) {
            super(string);
            this.algorithm = string;
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
            this.ecParams = (ECParameterSpec)ecParameters.get(new Integer(n));
            if (this.ecParams != null) {
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            }
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
            this.ecParams = (ECParameterSpec)algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            return new KeyPair(new JCEECPublicKey(this.algorithm, eCPublicKeyParameters, this.ecParams), new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters, this.ecParams));
        }

        static {
            ecParameters.put(new Integer(192), ECNamedCurveTable.getParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), ECNamedCurveTable.getParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), ECNamedCurveTable.getParameterSpec("prime256v1"));
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
                this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
            } else {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                object = new ElGamalParametersGenerator();
                ((ElGamalParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, ((ElGamalParametersGenerator)object).generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
            ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(elGamalPublicKeyParameters), new JCEElGamalPrivateKey(elGamalPrivateKeyParameters));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                object = new DSAParametersGenerator();
                ((DSAParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, ((DSAParametersGenerator)object).generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
            return new KeyPair(new JDKDSAPublicKey(dSAPublicKeyParameters), new JDKDSAPrivateKey(dSAPrivateKeyParameters));
        }
    }

    public static class DH
    extends JDKKeyPairGenerator {
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                object = new DHParametersGenerator();
                ((DHParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new DHKeyGenerationParameters(this.random, ((DHParametersGenerator)object).generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
            DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
            return new KeyPair(new JCEDHPublicKey(dHPublicKeyParameters), new JCEDHPrivateKey(dHPrivateKeyParameters));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 8;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 8);
            this.engine.init(this.param);
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, secureRandom, n, 8);
            this.engine.init(this.param);
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            this.param = new RSAKeyGenerationParameters(rSAKeyGenParameterSpec.getPublicExponent(), secureRandom, rSAKeyGenParameterSpec.getKeysize(), 8);
            this.engine.init(this.param);
        }

        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(rSAKeyParameters), new JCERSAPrivateCrtKey(rSAPrivateCrtKeyParameters));
        }
    }
}

