/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DESedeTest
implements Test {
    static String[] cipherTests1 = new String[]{"112", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "128", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "168", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89", "192", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89"};
    static byte[] input1 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
    static byte[] input2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c");
    static RC2ParameterSpec rc2Spec = new RC2ParameterSpec(128, Hex.decode("0123456789abcdef"));
    static RC5ParameterSpec rc5Spec = new RC5ParameterSpec(16, 16, 32, Hex.decode("0123456789abcdef"));
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;

    public String getName() {
        return "DESEDE";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2, int n) {
        if (byArray.length < n) {
            return false;
        }
        if (byArray2.length < n) {
            return false;
        }
        int n2 = 0;
        while (n2 != n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private TestResult wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        try {
            Object object;
            Cipher cipher = Cipher.getInstance("DESedeWrap", "INFOSEC");
            cipher.init(3, (Key)new SecretKeySpec(byArray, "DESEDE"), new IvParameterSpec(byArray2));
            try {
                object = cipher.wrap(new SecretKeySpec(byArray3, "DESEDE"));
                if (!this.equalArray((byte[])object, byArray4)) {
                    return new SimpleTestResult(false, this.getName() + ": failed wrap test " + n + " expected " + new String(Hex.encode(byArray4)) + " got " + new String(Hex.encode((byte[])object)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + exception.toString());
            }
            cipher.init(4, new SecretKeySpec(byArray, "DESEDE"));
            try {
                object = cipher.unwrap(byArray4, "DESede", 3);
                if (!this.equalArray(object.getEncoded(), byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(object.getEncoded())));
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception " + exception.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": failed exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult test(int n, byte[] byArray, byte[] byArray2) {
        Object object;
        Cipher cipher;
        Cipher cipher2;
        SecretKey secretKey;
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom();
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DESEDE", "INFOSEC");
            keyGenerator.init(n, (SecureRandom)fixedSecureRandom);
            secretKey = keyGenerator.generateKey();
            cipher2 = Cipher.getInstance("DESEDE/ECB/PKCS7Padding", "INFOSEC");
            cipher = Cipher.getInstance("DESEDE/ECB/PKCS7Padding", "INFOSEC");
            cipher.init(1, (Key)secretKey, (SecureRandom)fixedSecureRandom);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed initialisation - " + exception.toString());
        }
        try {
            cipher2.init(2, secretKey);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed initialisation - " + exception.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            int n2 = 0;
            while (n2 != byArray.length / 2) {
                cipherOutputStream.write(byArray[n2]);
                ++n2;
            }
            cipherOutputStream.write(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed encryption - " + iOException.toString());
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray3, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed encryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            object = new DataInputStream(cipherInputStream);
            byArray3 = new byte[byArray.length];
            int n3 = 0;
            while (n3 != byArray.length / 2) {
                byArray3[n3] = (byte)((FilterInputStream)object).read();
                ++n3;
            }
            ((DataInputStream)object).readFully(byArray3, byArray.length / 2, byArray3.length - byArray.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed encryption - " + exception.toString());
        }
        if (!this.equalArray(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed decryption - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
        try {
            object = SecretKeyFactory.getInstance("DESede", "INFOSEC");
            DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)((SecretKeyFactory)object).getKeySpec(secretKey, class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = DESedeTest.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec);
            if (!this.equalArray(secretKey.getEncoded(), dESedeKeySpec.getKey(), 16)) {
                return new SimpleTestResult(false, this.getName() + ": DESEDE KeySpec does not match key.");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": DESEDE failed keyspec - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": DESEDE Okay");
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        TestResult testResult;
        int n = 0;
        while (n != cipherTests1.length) {
            testResult = this.test(Integer.parseInt(cipherTests1[n]), input1, Hex.decode(cipherTests1[n + 1]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n += 2;
        }
        byte[] byArray4 = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
        testResult = this.wrapTest(1, byArray4, byArray3 = Hex.decode("5dd4cbfc96f5453b"), byArray2 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98"), byArray = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        DESedeTest dESedeTest = new DESedeTest();
        TestResult testResult = dESedeTest.perform();
        System.out.println(testResult.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FixedSecureRandom
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private FixedSecureRandom() {
        }

        public void nextBytes(byte[] byArray) {
            int n = 0;
            while (n + this.seed.length < byArray.length) {
                System.arraycopy(this.seed, 0, byArray, n, this.seed.length);
                n += this.seed.length;
            }
            System.arraycopy(this.seed, 0, byArray, n, byArray.length - n);
        }
    }
}

