/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.ocsp.BasicOCSPResponse;
import cn.com.infosec.ocsp.OCSPException;
import cn.com.infosec.ocsp.RespData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class BasicOCSPResp {
    BasicOCSPResponse resp;
    X509Certificate[] chain = null;

    public BasicOCSPResp(BasicOCSPResponse basicOCSPResponse) {
        this.resp = basicOCSPResponse;
    }

    public String getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.resp.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    public X509Certificate[] getCerts(String string) throws OCSPException, NoSuchProviderException {
        if (this.chain == null) {
            CertificateFactory certificateFactory;
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            try {
                certificateFactory = CertificateFactory.getInstance("X.509", string);
            }
            catch (CertificateException certificateException) {
                throw new OCSPException("can't get certificate factory.", certificateException);
            }
            ASN1Sequence aSN1Sequence = this.resp.getCerts();
            if (aSN1Sequence != null) {
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    try {
                        aSN1OutputStream.writeObject(enumeration.nextElement());
                        arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                    }
                    catch (IOException iOException) {
                        throw new OCSPException("can't re-encode certificate!", iOException);
                    }
                    catch (CertificateException certificateException) {
                        throw new OCSPException("can't re-encode certificate!", certificateException);
                    }
                    byteArrayOutputStream.reset();
                }
            }
            this.chain = arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return this.chain;
    }

    public boolean verify(PublicKey publicKey, String string) throws OCSPException, NoSuchProviderException {
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgOID(), string);
            signature.initVerify(publicKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(this.resp.getTbsResponseData());
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.resp);
        return byteArrayOutputStream.toByteArray();
    }
}

