/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.ocsp.BasicOCSPResponse;
import cn.com.infosec.asn1.ocsp.OCSPObjectIdentifiers;
import cn.com.infosec.asn1.ocsp.OCSPResponse;
import cn.com.infosec.asn1.ocsp.ResponseBytes;
import cn.com.infosec.ocsp.BasicOCSPResp;
import cn.com.infosec.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse oCSPResponse) {
        this.resp = oCSPResponse;
    }

    public OCSPResp(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public OCSPResp(InputStream inputStream) throws IOException {
        this.resp = OCSPResponse.getInstance(new ASN1InputStream(inputStream).readObject());
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes responseBytes = this.resp.getResponseBytes();
        if (responseBytes == null) {
            return null;
        }
        if (responseBytes.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(responseBytes.getResponse().getOctets()));
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(aSN1InputStream.readObject()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new OCSPException("problem decoding object: " + exception, exception);
            }
        }
        return responseBytes.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.resp);
        return byteArrayOutputStream.toByteArray();
    }
}

